/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xmlrpc;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.xmlrpc.Method;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class XmlRpcMethodUtil {
    private static Log _log = LogFactoryUtil.getLog(XmlRpcMethodUtil.class);
    private static XmlRpcMethodUtil _instance = new XmlRpcMethodUtil();
    private Map<String, Map<String, Method>> _methodRegistry = new ConcurrentHashMap<String, Map<String, Method>>();
    private ServiceRegistrationMap<Method> _serviceRegistrations = new ServiceRegistrationMap();
    private ServiceTracker<Method, Method> _serviceTracker;

    public static Method getMethod(String token, String methodName) {
        return _instance._getMethod(token, methodName);
    }

    public static void registerMethod(Method method) {
        if (method == null) {
            return;
        }
        _instance._registerMethod(method);
    }

    public static void unregisterMethod(Method method) {
        if (method == null) {
            return;
        }
        _instance._unregisterMethod(method);
    }

    protected Method _getMethod(String token, String methodName) {
        Method method = null;
        Map<String, Method> methods = this._methodRegistry.get(token);
        if (methods != null) {
            method = methods.get(methodName);
        }
        return method;
    }

    private XmlRpcMethodUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(Method.class, (ServiceTrackerCustomizer)new MethodServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private void _registerMethod(Method method) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(Method.class, (Object)method);
        this._serviceRegistrations.put((Object)method, (Object)serviceRegistration);
    }

    private void _unregisterMethod(Method method) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove((Object)method);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private class MethodServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Method, Method> {
        private MethodServiceTrackerCustomizer() {
        }

        public Method addingService(ServiceReference<Method> serviceReference) {
            String methodName;
            Method registeredMethod;
            Registry registry = RegistryUtil.getRegistry();
            Method method = (Method)registry.getService(serviceReference);
            String token = method.getToken();
            HashMap<String, Method> methods = (HashMap<String, Method>)XmlRpcMethodUtil.this._methodRegistry.get(token);
            if (methods == null) {
                methods = new HashMap<String, Method>();
                XmlRpcMethodUtil.this._methodRegistry.put(token, methods);
            }
            if ((registeredMethod = (Method)methods.get(methodName = method.getMethodName())) != null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("There is already an XML-RPC method registered with name " + methodName + " at " + token));
                }
            } else {
                methods.put(methodName, method);
            }
            return method;
        }

        public void modifiedService(ServiceReference<Method> serviceReference, Method method) {
        }

        public void removedService(ServiceReference<Method> serviceReference, Method method) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            String token = method.getToken();
            Map methods = (Map)XmlRpcMethodUtil.this._methodRegistry.get(token);
            if (methods == null) {
                return;
            }
            String methodName = method.getMethodName();
            methods.remove(methodName);
            if (methods.isEmpty()) {
                XmlRpcMethodUtil.this._methodRegistry.remove(token);
            }
        }
    }
}

