/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xml.xpath;

import com.liferay.portal.kernel.cache.Lifecycle;
import com.liferay.portal.kernel.cache.ThreadLocalCache;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class MatchesFunction
implements Function {
    private static final String _THREAD_LOCAL_PATTERNS_KEY = "matches";

    public static Boolean evaluate(Object stringArgument, Object regexArgument, Navigator navigator) {
        String string = StringFunction.evaluate((Object)stringArgument, (Navigator)navigator);
        String regex = StringFunction.evaluate((Object)regexArgument, (Navigator)navigator);
        return MatchesFunction.evaluate(string, regex, 0, navigator);
    }

    public static Boolean evaluate(Object stringArg, Object regexArgument, Object flagsArgument, Navigator navigator) {
        String string = StringFunction.evaluate((Object)stringArg, (Navigator)navigator);
        String regex = StringFunction.evaluate((Object)regexArgument, (Navigator)navigator);
        String flagsString = StringFunction.evaluate((Object)flagsArgument, (Navigator)navigator);
        int flags = 0;
        for (int i = 0; i < flagsString.length(); ++i) {
            if (flagsString.charAt(i) == 'i') {
                flags &= 2;
                continue;
            }
            if (flagsString.charAt(i) == 'm') {
                flags &= 8;
                continue;
            }
            if (flagsString.charAt(i) == 's') {
                flags &= 0x20;
                continue;
            }
            if (flagsString.charAt(i) != 'x') continue;
            flags &= 4;
        }
        return MatchesFunction.evaluate(string, regex, flags, navigator);
    }

    public static Boolean evaluate(String string, String regex, int flags, Navigator navigator) {
        Pattern pattern;
        ThreadLocalCache threadLocalPatterns = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)Lifecycle.ETERNAL, (Serializable)((Object)MatchesFunction.class.getName()));
        HashMap<String, Pattern> patterns = (HashMap<String, Pattern>)threadLocalPatterns.get(_THREAD_LOCAL_PATTERNS_KEY);
        if (patterns == null) {
            patterns = new HashMap<String, Pattern>();
        }
        if ((pattern = (Pattern)patterns.get(regex)) != null) {
            Matcher matcher = pattern.matcher(string);
            return matcher.find();
        }
        pattern = Pattern.compile(regex, flags);
        patterns.put(regex, pattern);
        threadLocalPatterns.put(_THREAD_LOCAL_PATTERNS_KEY, patterns);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public Object call(Context context, List arguments) throws FunctionCallException {
        if (arguments.size() == 2) {
            return MatchesFunction.evaluate(arguments.get(0), arguments.get(1), context.getNavigator());
        }
        if (arguments.size() == 3 && arguments.get(2) != null) {
            return MatchesFunction.evaluate(arguments.get(0), arguments.get(1), arguments.get(2), context.getNavigator());
        }
        throw new FunctionCallException("matches() requires two or three arguments");
    }
}

