/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xml;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Entity;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.Text;
import com.liferay.portal.kernel.xml.XMLSchema;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.EntityResolver;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.xml.AttributeImpl;
import com.liferay.portal.xml.DocumentImpl;
import com.liferay.portal.xml.ElementImpl;
import com.liferay.portal.xml.EntityImpl;
import com.liferay.portal.xml.NamespaceImpl;
import com.liferay.portal.xml.NodeImpl;
import com.liferay.portal.xml.NodeList;
import com.liferay.portal.xml.ProcessingInstructionImpl;
import com.liferay.portal.xml.QNameImpl;
import com.liferay.portal.xml.TextImpl;
import com.liferay.portal.xml.XPathImpl;
import com.liferay.util.xml.XMLSafeReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xerces.parsers.SAXParser;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.xml.sax.XMLReader;

@DoPrivileged
public class SAXReaderImpl
implements com.liferay.portal.kernel.xml.SAXReader {
    private static final String _FEATURES_DYNAMIC = "http://apache.org/xml/features/validation/dynamic";
    private static final String _FEATURES_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String _FEATURES_LOAD_DTD_GRAMMAR = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    private static final String _FEATURES_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String _FEATURES_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String _FEATURES_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    private static final String _FEATURES_VALIDATION_SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String _PROPERTY_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String _PROPERTY_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static Log _log = LogFactoryUtil.getLog(SAXReaderImpl.class);
    private static SAXReaderImpl _instance = new SAXReaderImpl();
    private DocumentFactory _documentFactory = DocumentFactory.getInstance();

    public static SAXReaderImpl getInstance() {
        return _instance;
    }

    public static List<Attribute> toNewAttributes(List<org.dom4j.Attribute> oldAttributes) {
        ArrayList<AttributeImpl> newAttributes = new ArrayList<AttributeImpl>(oldAttributes.size());
        for (org.dom4j.Attribute oldAttribute : oldAttributes) {
            newAttributes.add(new AttributeImpl(oldAttribute));
        }
        return new NodeList(newAttributes, oldAttributes);
    }

    public static List<Element> toNewElements(List<org.dom4j.Element> oldElements) {
        ArrayList<ElementImpl> newElements = new ArrayList<ElementImpl>(oldElements.size());
        for (org.dom4j.Element oldElement : oldElements) {
            newElements.add(new ElementImpl(oldElement));
        }
        return new NodeList(newElements, oldElements);
    }

    public static List<com.liferay.portal.kernel.xml.Namespace> toNewNamespaces(List<Namespace> oldNamespaces) {
        ArrayList<NamespaceImpl> newNamespaces = new ArrayList<NamespaceImpl>(oldNamespaces.size());
        for (Namespace oldNamespace : oldNamespaces) {
            newNamespaces.add(new NamespaceImpl(oldNamespace));
        }
        return new NodeList(newNamespaces, oldNamespaces);
    }

    public static List<Node> toNewNodes(List<org.dom4j.Node> oldNodes) {
        ArrayList<NodeImpl> newNodes = new ArrayList<NodeImpl>(oldNodes.size());
        for (org.dom4j.Node oldNode : oldNodes) {
            if (oldNode instanceof org.dom4j.Element) {
                newNodes.add(new ElementImpl((org.dom4j.Element)oldNode));
                continue;
            }
            newNodes.add(new NodeImpl(oldNode));
        }
        return new NodeList(newNodes, oldNodes);
    }

    public static List<com.liferay.portal.kernel.xml.ProcessingInstruction> toNewProcessingInstructions(List<ProcessingInstruction> oldProcessingInstructions) {
        ArrayList<ProcessingInstructionImpl> newProcessingInstructions = new ArrayList<ProcessingInstructionImpl>(oldProcessingInstructions.size());
        for (ProcessingInstruction oldProcessingInstruction : oldProcessingInstructions) {
            newProcessingInstructions.add(new ProcessingInstructionImpl(oldProcessingInstruction));
        }
        return new NodeList(newProcessingInstructions, oldProcessingInstructions);
    }

    public static List<org.dom4j.Attribute> toOldAttributes(List<Attribute> newAttributes) {
        ArrayList<org.dom4j.Attribute> oldAttributes = new ArrayList<org.dom4j.Attribute>(newAttributes.size());
        for (Attribute newAttribute : newAttributes) {
            AttributeImpl newAttributeImpl = (AttributeImpl)newAttribute;
            oldAttributes.add(newAttributeImpl.getWrappedAttribute());
        }
        return oldAttributes;
    }

    public static List<org.dom4j.Node> toOldNodes(List<Node> newNodes) {
        ArrayList<org.dom4j.Node> oldNodes = new ArrayList<org.dom4j.Node>(newNodes.size());
        for (Node newNode : newNodes) {
            NodeImpl newNodeImpl = (NodeImpl)newNode;
            oldNodes.add(newNodeImpl.getWrappedNode());
        }
        return oldNodes;
    }

    public static List<ProcessingInstruction> toOldProcessingInstructions(List<com.liferay.portal.kernel.xml.ProcessingInstruction> newProcessingInstructions) {
        ArrayList<ProcessingInstruction> oldProcessingInstructions = new ArrayList<ProcessingInstruction>(newProcessingInstructions.size());
        for (com.liferay.portal.kernel.xml.ProcessingInstruction newProcessingInstruction : newProcessingInstructions) {
            ProcessingInstructionImpl newProcessingInstructionImpl = (ProcessingInstructionImpl)newProcessingInstruction;
            oldProcessingInstructions.add(newProcessingInstructionImpl.getWrappedProcessingInstruction());
        }
        return oldProcessingInstructions;
    }

    public Attribute createAttribute(Element element, QName qName, String value) {
        ElementImpl elementImpl = (ElementImpl)element;
        QNameImpl qNameImpl = (QNameImpl)qName;
        return new AttributeImpl(this._documentFactory.createAttribute(elementImpl.getWrappedElement(), qNameImpl.getWrappedQName(), value));
    }

    public Attribute createAttribute(Element element, String name, String value) {
        ElementImpl elementImpl = (ElementImpl)element;
        return new AttributeImpl(this._documentFactory.createAttribute(elementImpl.getWrappedElement(), name, value));
    }

    public Document createDocument() {
        return new DocumentImpl(this._documentFactory.createDocument());
    }

    public Document createDocument(Element rootElement) {
        ElementImpl rootElementImpl = (ElementImpl)rootElement;
        return new DocumentImpl(this._documentFactory.createDocument(rootElementImpl.getWrappedElement()));
    }

    public Document createDocument(String encoding) {
        return new DocumentImpl(this._documentFactory.createDocument(encoding));
    }

    public Element createElement(QName qName) {
        QNameImpl qNameImpl = (QNameImpl)qName;
        return new ElementImpl(this._documentFactory.createElement(qNameImpl.getWrappedQName()));
    }

    public Element createElement(String name) {
        return new ElementImpl(this._documentFactory.createElement(name));
    }

    public Entity createEntity(String name, String text) {
        return new EntityImpl(this._documentFactory.createEntity(name, text));
    }

    public com.liferay.portal.kernel.xml.Namespace createNamespace(String uri) {
        return new NamespaceImpl(Namespace.get((String)uri));
    }

    public com.liferay.portal.kernel.xml.Namespace createNamespace(String prefix, String uri) {
        return new NamespaceImpl(this._documentFactory.createNamespace(prefix, uri));
    }

    public com.liferay.portal.kernel.xml.ProcessingInstruction createProcessingInstruction(String target, Map<String, String> data) {
        ProcessingInstruction processingInstruction = this._documentFactory.createProcessingInstruction(target, data);
        if (processingInstruction == null) {
            return null;
        }
        return new ProcessingInstructionImpl(processingInstruction);
    }

    public com.liferay.portal.kernel.xml.ProcessingInstruction createProcessingInstruction(String target, String data) {
        ProcessingInstruction processingInstruction = this._documentFactory.createProcessingInstruction(target, data);
        if (processingInstruction == null) {
            return null;
        }
        return new ProcessingInstructionImpl(processingInstruction);
    }

    public QName createQName(String localName) {
        return new QNameImpl(this._documentFactory.createQName(localName));
    }

    public QName createQName(String localName, com.liferay.portal.kernel.xml.Namespace namespace) {
        NamespaceImpl namespaceImpl = (NamespaceImpl)namespace;
        return new QNameImpl(this._documentFactory.createQName(localName, namespaceImpl.getWrappedNamespace()));
    }

    public Text createText(String text) {
        return new TextImpl(this._documentFactory.createText(text));
    }

    public com.liferay.portal.kernel.xml.XPath createXPath(String xPathExpression) {
        return this.createXPath(xPathExpression, null);
    }

    public com.liferay.portal.kernel.xml.XPath createXPath(String xPathExpression, Map<String, String> namespaceContextMap) {
        return new XPathImpl(this._documentFactory.createXPath(xPathExpression), namespaceContextMap);
    }

    public com.liferay.portal.kernel.xml.XPath createXPath(String xPathExpression, String prefix, String namespace) {
        HashMap<String, String> namespaceContextMap = new HashMap<String, String>();
        namespaceContextMap.put(prefix, namespace);
        return this.createXPath(xPathExpression, namespaceContextMap);
    }

    public Document read(File file) throws DocumentException {
        return this.read(file, false);
    }

    public Document read(File file, boolean validate) throws DocumentException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            if (contextClassLoader != classLoader) {
                ClassLoaderUtil.setContextClassLoader(classLoader);
            }
            SAXReader saxReader = this.getSAXReader(validate);
            DocumentImpl documentImpl = new DocumentImpl(saxReader.read(file));
            return documentImpl;
        }
        catch (org.dom4j.DocumentException de) {
            throw new DocumentException(de.getMessage(), (Throwable)de);
        }
        finally {
            if (contextClassLoader != classLoader) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Document read(InputStream is) throws DocumentException {
        return this.read(is, false);
    }

    public Document read(InputStream is, boolean validate) throws DocumentException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            if (contextClassLoader != classLoader) {
                ClassLoaderUtil.setContextClassLoader(classLoader);
            }
            SAXReader saxReader = this.getSAXReader(validate);
            DocumentImpl documentImpl = new DocumentImpl(saxReader.read(is));
            return documentImpl;
        }
        catch (org.dom4j.DocumentException de) {
            throw new DocumentException(de.getMessage(), (Throwable)de);
        }
        finally {
            if (contextClassLoader != classLoader) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Document read(Reader reader) throws DocumentException {
        return this.read(reader, false);
    }

    public Document read(Reader reader, boolean validate) throws DocumentException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            if (contextClassLoader != classLoader) {
                ClassLoaderUtil.setContextClassLoader(classLoader);
            }
            SAXReader saxReader = this.getSAXReader(validate);
            DocumentImpl documentImpl = new DocumentImpl(saxReader.read(reader));
            return documentImpl;
        }
        catch (org.dom4j.DocumentException de) {
            throw new DocumentException(de.getMessage(), (Throwable)de);
        }
        finally {
            if (contextClassLoader != classLoader) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Document read(String xml) throws DocumentException {
        return this.read((Reader)new XMLSafeReader(xml));
    }

    public Document read(String xml, boolean validate) throws DocumentException {
        return this.read((Reader)new XMLSafeReader(xml), validate);
    }

    public Document read(String xml, XMLSchema xmlSchema) throws DocumentException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            if (contextClassLoader != classLoader) {
                ClassLoaderUtil.setContextClassLoader(classLoader);
            }
            SAXReader saxReader = this.getSAXReader(xmlSchema);
            XMLSafeReader reader = new XMLSafeReader(xml);
            DocumentImpl documentImpl = new DocumentImpl(saxReader.read((Reader)reader));
            return documentImpl;
        }
        catch (org.dom4j.DocumentException de) {
            throw new DocumentException(de.getMessage(), (Throwable)de);
        }
        finally {
            if (contextClassLoader != classLoader) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Document read(URL url) throws DocumentException {
        return this.read(url, false);
    }

    public Document read(URL url, boolean validate) throws DocumentException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            if (contextClassLoader != classLoader) {
                ClassLoaderUtil.setContextClassLoader(classLoader);
            }
            SAXReader saxReader = this.getSAXReader(validate);
            DocumentImpl documentImpl = new DocumentImpl(saxReader.read(url));
            return documentImpl;
        }
        catch (org.dom4j.DocumentException de) {
            throw new DocumentException(de.getMessage(), (Throwable)de);
        }
        finally {
            if (contextClassLoader != classLoader) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Document readURL(String url) throws DocumentException, MalformedURLException {
        return this.read(new URL(url), false);
    }

    public Document readURL(String url, boolean validate) throws DocumentException, MalformedURLException {
        return this.read(new URL(url), validate);
    }

    public List<Node> selectNodes(String xPathFilterExpression, List<Node> nodes) {
        XPath xPath = this._documentFactory.createXPath(xPathFilterExpression);
        return SAXReaderImpl.toNewNodes(xPath.selectNodes(SAXReaderImpl.toOldNodes(nodes)));
    }

    public List<Node> selectNodes(String xPathFilterExpression, Node node) {
        NodeImpl nodeImpl = (NodeImpl)node;
        XPath xPath = this._documentFactory.createXPath(xPathFilterExpression);
        return SAXReaderImpl.toNewNodes(xPath.selectNodes((Object)nodeImpl.getWrappedNode()));
    }

    public void sort(List<Node> nodes, String xPathExpression) {
        XPath xPath = this._documentFactory.createXPath(xPathExpression);
        xPath.sort(SAXReaderImpl.toOldNodes(nodes));
    }

    public void sort(List<Node> nodes, String xPathExpression, boolean distinct) {
        XPath xPath = this._documentFactory.createXPath(xPathExpression);
        xPath.sort(SAXReaderImpl.toOldNodes(nodes), distinct);
    }

    protected SAXReader getSAXReader(boolean validate) {
        SAXReader reader = null;
        if (!PropsValues.XML_VALIDATION_ENABLED) {
            validate = false;
        }
        try {
            reader = new SAXReader((XMLReader)new SAXParser(), validate);
            reader.setEntityResolver((org.xml.sax.EntityResolver)new EntityResolver());
            reader.setFeature(_FEATURES_DYNAMIC, validate);
            reader.setFeature(_FEATURES_EXTERNAL_GENERAL_ENTITIES, validate);
            reader.setFeature(_FEATURES_LOAD_DTD_GRAMMAR, validate);
            reader.setFeature(_FEATURES_LOAD_EXTERNAL_DTD, validate);
            reader.setFeature(_FEATURES_VALIDATION, validate);
            reader.setFeature(_FEATURES_VALIDATION_SCHEMA, validate);
            reader.setFeature(_FEATURES_VALIDATION_SCHEMA_FULL_CHECKING, validate);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("XSD validation is disabled because " + e.getMessage()));
            }
            reader = new SAXReader(false);
            reader.setEntityResolver((org.xml.sax.EntityResolver)new EntityResolver());
        }
        return reader;
    }

    protected SAXReader getSAXReader(XMLSchema xmlSchema) {
        SAXReader saxReader;
        block4: {
            boolean validate = true;
            if (!PropsValues.XML_VALIDATION_ENABLED) {
                validate = false;
            }
            saxReader = this.getSAXReader(validate);
            if (xmlSchema == null || !validate) {
                return saxReader;
            }
            try {
                saxReader.setProperty(_PROPERTY_SCHEMA_LANGUAGE, (Object)xmlSchema.getSchemaLanguage());
                saxReader.setProperty(_PROPERTY_SCHEMA_SOURCE, (Object)xmlSchema.getSchemaSource());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("XSD validation is disabled because " + e.getMessage()));
            }
        }
        return saxReader;
    }
}

