/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowTaskManagerUtil;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermission;
import com.liferay.portal.model.WorkflowInstanceLink;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.service.WorkflowInstanceLinkLocalServiceUtil;

@DoPrivileged
public class WorkflowPermissionImpl
implements WorkflowPermission {
    private static Log _log = LogFactoryUtil.getLog(WorkflowPermissionImpl.class);

    public Boolean hasPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK, String actionId) {
        try {
            return this.doHasPermission(permissionChecker, groupId, className, classPK, actionId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    protected Boolean doHasPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK, String actionId) throws Exception {
        long companyId = permissionChecker.getCompanyId();
        if (permissionChecker.isCompanyAdmin() || permissionChecker.isGroupAdmin(groupId)) {
            return Boolean.TRUE;
        }
        if (!WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)companyId, (long)groupId, (String)className)) {
            return null;
        }
        if (WorkflowInstanceLinkLocalServiceUtil.hasWorkflowInstanceLink((long)companyId, (long)groupId, (String)className, (long)classPK)) {
            WorkflowInstanceLink workflowInstanceLink = WorkflowInstanceLinkLocalServiceUtil.getWorkflowInstanceLink((long)companyId, (long)groupId, (String)className, (long)classPK);
            WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance((long)companyId, (long)workflowInstanceLink.getWorkflowInstanceId());
            if (workflowInstance.isComplete()) {
                return null;
            }
            boolean hasPermission = this.hasImplicitPermission(permissionChecker, workflowInstance);
            if (!hasPermission && actionId.equals("VIEW")) {
                return null;
            }
            return hasPermission;
        }
        return null;
    }

    protected boolean hasImplicitPermission(PermissionChecker permissionChecker, WorkflowInstance workflowInstance) throws WorkflowException {
        if (WorkflowTaskManagerUtil.getWorkflowTaskCountByWorkflowInstance((long)permissionChecker.getCompanyId(), (Long)permissionChecker.getUserId(), (long)workflowInstance.getWorkflowInstanceId(), (Boolean)Boolean.FALSE) > 0) {
            return true;
        }
        return WorkflowTaskManagerUtil.getWorkflowTaskCountByUserRoles((long)permissionChecker.getCompanyId(), (long)permissionChecker.getUserId(), (Boolean)Boolean.FALSE) > 0;
    }
}

