/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.words;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.jazzy.InvalidWord;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.words.Words;
import com.liferay.portal.words.BasicSpellCheckListener;
import com.liferay.util.ContentUtil;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.DefaultWordFinder;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordFinder;
import com.swabunga.spell.event.WordTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class WordsImpl
implements Words {
    private static Log _log = LogFactoryUtil.getLog(WordsImpl.class);
    private List<String> _dictionaryList;
    private Set<String> _dictionarySet;
    private SpellDictionaryHashMap _spellDictionaryHashMap;

    public List<InvalidWord> checkSpelling(String text) {
        SpellChecker spellChecker = new SpellChecker((SpellDictionary)this.getSpellDictionaryHashMap());
        BasicSpellCheckListener basicSpellCheckListener = new BasicSpellCheckListener(text);
        spellChecker.addSpellCheckListener((SpellCheckListener)basicSpellCheckListener);
        spellChecker.checkSpelling((WordTokenizer)new StringWordTokenizer((WordFinder)new DefaultWordFinder(text)));
        return basicSpellCheckListener.getInvalidWords();
    }

    public List<String> getDictionaryList() {
        if (this._dictionaryList == null) {
            this._dictionaryList = ListUtil.fromArray((Object[])StringUtil.splitLines((String)ContentUtil.get((String)"com/liferay/portal/words/dependencies/words.txt")));
        }
        return this._dictionaryList;
    }

    public Set<String> getDictionarySet() {
        if (this._dictionarySet == null) {
            this._dictionarySet = new HashSet<String>(this.getDictionaryList());
        }
        return this._dictionarySet;
    }

    public String getRandomWord() {
        List<String> dictionaryList = this.getDictionaryList();
        Random random = new Random(SecureRandomUtil.nextLong());
        int pos = random.nextInt(dictionaryList.size());
        return dictionaryList.get(pos);
    }

    public boolean isDictionaryWord(String word) {
        Set<String> dictionarySet = this.getDictionarySet();
        return dictionarySet.contains(word);
    }

    protected SpellDictionaryHashMap getSpellDictionaryHashMap() {
        if (this._spellDictionaryHashMap != null) {
            return this._spellDictionaryHashMap;
        }
        try {
            this._spellDictionaryHashMap = new SpellDictionaryHashMap();
            String[] dics = new String[]{"center.dic", "centre.dic", "color.dic", "colour.dic", "eng_com.dic", "english.0", "english.1", "ise.dic", "ize.dic", "labeled.dic", "labelled.dic", "yse.dic", "yze.dic"};
            for (int i = 0; i < dics.length; ++i) {
                this._spellDictionaryHashMap.addDictionary((Reader)new UnsyncStringReader(ContentUtil.get((String)("com/liferay/portal/words/dependencies/" + dics[i]))));
            }
        }
        catch (IOException ioe) {
            _log.error((Throwable)ioe);
        }
        return this._spellDictionaryHashMap;
    }
}

