/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.methods.Method;
import com.liferay.portal.kernel.webdav.methods.MethodFactory;
import com.liferay.portal.util.PropsUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class MethodFactoryImpl
implements MethodFactory {
    private Map<String, Object> _methods = new HashMap<String, Object>();

    public MethodFactoryImpl() throws Exception {
        for (String methodName : Method.SUPPORTED_METHOD_NAMES) {
            this.addMethod(methodName);
        }
    }

    public Method create(HttpServletRequest request) throws WebDAVException {
        String method = request.getMethod();
        Method methodImpl = (Method)this._methods.get(StringUtil.toUpperCase((String)method));
        if (methodImpl == null) {
            throw new WebDAVException("Method " + method + " is not implemented");
        }
        return methodImpl;
    }

    protected void addMethod(String methodName) throws Exception {
        String defaultClassName = methodName.substring(1);
        defaultClassName = StringUtil.toLowerCase((String)defaultClassName);
        defaultClassName = methodName.substring(0, 1) + defaultClassName;
        defaultClassName = "com.liferay.portal.webdav.methods." + defaultClassName + "MethodImpl";
        String className = GetterUtil.getString((String)PropsUtil.get(MethodFactoryImpl.class.getName() + "." + methodName), (String)defaultClassName);
        this._methods.put(methodName, InstanceFactory.newInstance((String)className));
    }
}

