/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

public class CompanyWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    public Resource getResource(WebDAVRequest webDAVRequest) {
        String path = this.getRootPath() + webDAVRequest.getPath();
        return new BaseResourceImpl(path, "", "");
    }

    public List<Resource> getResources(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            long userId = webDAVRequest.getUserId();
            return this.getResources(userId);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    protected List<Resource> getResources(long userId) throws Exception {
        User user = UserLocalServiceUtil.getUserById((long)userId);
        List groups = WebDAVUtil.getGroups((User)user);
        ArrayList<Resource> resources = new ArrayList<Resource>(groups.size());
        for (Group group : groups) {
            String parentPath = this.getRootPath();
            String name = group.getFriendlyURL();
            name = name.substring(1);
            resources.add((Resource)new BaseResourceImpl(parentPath, name, name));
        }
        return resources;
    }
}

