/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.ClassName;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class VerifyWorkflow
extends VerifyProcess {
    private static final String[][] _ORPHANED_ATTACHED_MODELS = new String[][]{{"com.liferay.portal.workflow.kaleo.forms.model.KaleoProcess", "KaleoProcess", "kaleoProcessId"}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteOrphanedWorkflowDefinitionLinks() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select distinct classNameId from WorkflowDefinitionLink");
            rs = ps.executeQuery();
            while (rs.next()) {
                long classNameId = rs.getLong("classNameId");
                ClassName className = ClassNameLocalServiceUtil.fetchClassName((long)classNameId);
                if (className == null) continue;
                String classNameValue = className.getValue();
                for (String[] orphanedAttachedModel : this.getOrphanedAttachedModels()) {
                    String orphanedClassName = orphanedAttachedModel[0];
                    if (!classNameValue.equals(orphanedClassName)) continue;
                    String orphanedTableName = orphanedAttachedModel[1];
                    String orphanedColumnName = orphanedAttachedModel[2];
                    this.deleteOrphanedWorkflowDefinitionLinks(orphanedTableName, orphanedColumnName);
                }
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void deleteOrphanedWorkflowDefinitionLinks(String tableName, String columnName) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append("delete from WorkflowDefinitionLink where classPK not ");
        sb.append("in (select ");
        sb.append(columnName);
        sb.append(" from ");
        sb.append(tableName);
        sb.append(")");
        this.runSQL(sb.toString());
    }

    @Override
    protected void doVerify() throws Exception {
        this.deleteOrphanedWorkflowDefinitionLinks();
    }

    protected String[][] getOrphanedAttachedModels() {
        return _ORPHANED_ATTACHED_MODELS;
    }
}

