/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageResourceLocalServiceUtil;
import com.liferay.portlet.wiki.util.comparator.PageVersionComparator;
import java.util.Date;
import java.util.List;

public class VerifyWiki
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyWiki.class);

    @Override
    protected void doVerify() throws Exception {
        this.verifyCreateDate();
        this.verifyNoAssetPages();
    }

    protected void verifyCreateDate() throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = WikiPageResourceLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) {
                WikiPageResource pageResource = (WikiPageResource)object;
                VerifyWiki.this.verifyCreateDate(pageResource);
            }
        });
        actionableDynamicQuery.performActions();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Create dates verified for pages");
        }
    }

    protected void verifyCreateDate(WikiPageResource pageResource) {
        List pages = WikiPageLocalServiceUtil.getPages((long)pageResource.getNodeId(), (String)pageResource.getTitle(), (int)-1, (int)-1, (OrderByComparator)new PageVersionComparator(true));
        if (pages.size() <= 1) {
            return;
        }
        WikiPage firstPage = (WikiPage)pages.get(0);
        Date createDate = firstPage.getCreateDate();
        for (WikiPage page : pages) {
            if (createDate.equals(page.getCreateDate())) continue;
            page.setCreateDate(createDate);
            WikiPageLocalServiceUtil.updateWikiPage((WikiPage)page);
        }
    }

    protected void verifyNoAssetPages() throws Exception {
        List pages = WikiPageLocalServiceUtil.getNoAssetPages();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + pages.size() + " pages with no asset"));
        }
        for (WikiPage page : pages) {
            try {
                WikiPageLocalServiceUtil.updateAsset((long)page.getUserId(), (WikiPage)page, null, null, null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for page " + page.getPageId() + ": " + e.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for pages");
        }
    }
}

