/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portal.verify.model.VerifiableUUIDModel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Map;

public class VerifyUUID
extends VerifyProcess {
    public static void verify(VerifiableUUIDModel ... verifiableUUIDModels) throws Exception {
        for (VerifiableUUIDModel verifiableUUIDModel : verifiableUUIDModels) {
            VerifyUUID.verifyUUID(verifiableUUIDModel);
        }
    }

    protected static void updateUUID(VerifiableUUIDModel verifiableUUIDModel, long primKey) throws Exception {
        DB db = DBFactoryUtil.getDB();
        StringBundler sb = new StringBundler(8);
        sb.append("update ");
        sb.append(verifiableUUIDModel.getTableName());
        sb.append(" set uuid_ = '");
        sb.append(PortalUUIDUtil.generate());
        sb.append("' where ");
        sb.append(verifiableUUIDModel.getPrimaryKeyColumnName());
        sb.append(" = ");
        sb.append(primKey);
        db.runSQL(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void verifyUUID(VerifiableUUIDModel verifiableUUIDModel) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select " + verifiableUUIDModel.getPrimaryKeyColumnName() + " from " + verifiableUUIDModel.getTableName() + " where uuid_ is null or uuid_ = ''");
            rs = ps.executeQuery();
            while (rs.next()) {
                long pk = rs.getLong(verifiableUUIDModel.getPrimaryKeyColumnName());
                VerifyUUID.updateUUID(verifiableUUIDModel, pk);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    @Override
    protected void doVerify() throws Exception {
        Map verifiableUUIDModelsMap = PortalBeanLocatorUtil.locate(VerifiableUUIDModel.class);
        Collection verifiableUUIDModels = verifiableUUIDModelsMap.values();
        VerifyUUID.verify(verifiableUUIDModels.toArray(new VerifiableUUIDModel[verifiableUUIDModels.size()]));
    }
}

