/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.SystemEvent;
import com.liferay.portal.service.SystemEventLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceUtil;
import java.util.List;

public class VerifySystemEvent
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifySystemEvent.class);

    @Override
    protected void doVerify() throws Exception {
        this.verifyJournalArticleDeleteSystemEvents();
    }

    protected void verifyJournalArticleDeleteSystemEvents() throws Exception {
        DynamicQuery dynamicQuery = SystemEventLocalServiceUtil.dynamicQuery();
        Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
        dynamicQuery.add(classNameIdProperty.eq((Object)PortalUtil.getClassNameId(JournalArticle.class)));
        Property typeProperty = PropertyFactoryUtil.forName((String)"type");
        dynamicQuery.add(typeProperty.eq((Object)1));
        List systemEvents = SystemEventLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + systemEvents.size() + " delete system events " + "for journal articles"));
        }
        for (SystemEvent systemEvent : systemEvents) {
            JournalArticle journalArticle;
            JournalArticleResource journalArticleResource;
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)systemEvent.getExtraData());
            if (extraDataJSONObject.has("uuid") || !extraDataJSONObject.has("version") || (journalArticleResource = JournalArticleResourceLocalServiceUtil.fetchJournalArticleResourceByUuidAndGroupId((String)systemEvent.getClassUuid(), (long)systemEvent.getGroupId())) == null || (journalArticle = JournalArticleLocalServiceUtil.fetchArticle((long)systemEvent.getGroupId(), (String)journalArticleResource.getArticleId(), (double)extraDataJSONObject.getDouble("version"))) == null || journalArticle.isInTrash()) continue;
            SystemEventLocalServiceUtil.deleteSystemEvent((SystemEvent)systemEvent);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Delete system events verified for journal articles");
        }
    }
}

