/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.NoSuchResourcePermissionException;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ContactLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portal.verify.model.VerifiableResourcedModel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class VerifyResourcePermissions
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyResourcePermissions.class);

    public void verify(VerifiableResourcedModel ... verifiableResourcedModels) throws Exception {
        long[] companyIds;
        for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Owner");
            for (VerifiableResourcedModel verifiableResourcedModel : verifiableResourcedModels) {
                this.verifyResourcedModel(role, verifiableResourcedModel.getModelName(), verifiableResourcedModel.getTableName(), verifiableResourcedModel.getPrimaryKeyColumnName());
            }
            this.verifyLayout(role);
        }
    }

    @Override
    protected void doVerify() throws Exception {
        Map verifiableResourcedModelsMap = PortalBeanLocatorUtil.locate(VerifiableResourcedModel.class);
        Collection verifiableResourcedModels = verifiableResourcedModelsMap.values();
        this.verify(verifiableResourcedModels.toArray(new VerifiableResourcedModel[verifiableResourcedModels.size()]));
    }

    protected void verifyLayout(Role role) throws Exception {
        List layouts = LayoutLocalServiceUtil.getNoPermissionLayouts((long)role.getRoleId());
        int total = layouts.size();
        for (int i = 0; i < total; ++i) {
            Layout layout = (Layout)layouts.get(i);
            this.verifyResourcedModel(role.getCompanyId(), Layout.class.getName(), layout.getPlid(), role, 0L, i, total);
        }
    }

    protected void verifyResourcedModel(long companyId, String modelName, long primKey, Role role, long ownerId, int cur, int total) throws Exception {
        Contact contact;
        User user;
        if (_log.isInfoEnabled() && cur % 100 == 0) {
            _log.info((Object)("Processed " + cur + " of " + total + " resource permissions " + "for company = " + companyId + " and model " + modelName));
        }
        ResourcePermission resourcePermission = null;
        try {
            resourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)companyId, (String)modelName, (int)4, (String)String.valueOf(primKey), (long)role.getRoleId());
        }
        catch (NoSuchResourcePermissionException nsrpe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No resource found for {" + companyId + ", " + modelName + ", " + 4 + ", " + primKey + ", " + role.getRoleId() + "}"));
            }
            ResourceLocalServiceUtil.addResources((long)companyId, (long)0L, (long)ownerId, (String)modelName, (String)String.valueOf(primKey), (boolean)false, (boolean)false, (boolean)false);
        }
        if (resourcePermission == null) {
            try {
                resourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)companyId, (String)modelName, (int)4, (String)String.valueOf(primKey), (long)role.getRoleId());
            }
            catch (NoSuchResourcePermissionException nsrpe) {
                return;
            }
        }
        if (modelName.equals(User.class.getName()) && (user = UserLocalServiceUtil.fetchUserById((long)ownerId)) != null && (contact = ContactLocalServiceUtil.fetchContact((long)user.getContactId())) != null) {
            ownerId = contact.getUserId();
        }
        if (ownerId != resourcePermission.getOwnerId()) {
            resourcePermission.setOwnerId(ownerId);
            ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)resourcePermission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyResourcedModel(Role role, String modelName, String tableName, String primaryKeyColumnName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int total = 0;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select count(*) from " + tableName + " where companyId = " + role.getCompanyId());
            rs = ps.executeQuery();
            if (rs.next()) {
                total = rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select " + primaryKeyColumnName + ", userId from " + tableName + " where companyId = " + role.getCompanyId());
            rs = ps.executeQuery();
            int i = 0;
            while (rs.next()) {
                long primKey = rs.getLong(primaryKeyColumnName);
                long userId = rs.getLong("userId");
                this.verifyResourcedModel(role.getCompanyId(), modelName, primKey, role, userId, i, total);
                ++i;
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
    }
}

