/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.BaseDBProcess;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.verify.VerifyException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class VerifyProcess
extends BaseDBProcess {
    public static final int ALWAYS = -1;
    public static final int NEVER = 0;
    public static final int ONCE = 1;
    private static Log _log = LogFactoryUtil.getLog(VerifyProcess.class);
    private Pattern _createTablePattern = Pattern.compile("create table (\\S*) \\(");
    private Set<String> _portalTableNames;

    public void verify() throws VerifyException {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Verifying " + ((Object)((Object)this)).getClass().getName()));
            }
            this.doVerify();
        }
        catch (Exception e) {
            throw new VerifyException(e);
        }
    }

    public void verify(VerifyProcess verifyProcess) throws VerifyException {
        verifyProcess.verify();
    }

    protected void doVerify() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getBuildNumber() throws Exception {
        int n;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select buildNumber from Release_ where servletContextName = ?");
            ps.setString(1, "portal");
            rs = ps.executeQuery();
            rs.next();
            n = rs.getInt(1);
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return n;
    }

    protected Set<String> getPortalTableNames() throws Exception {
        if (this._portalTableNames != null) {
            return this._portalTableNames;
        }
        ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
        String sql = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/sql/dependencies/portal-tables.sql");
        Matcher matcher = this._createTablePattern.matcher(sql);
        HashSet<String> tableNames = new HashSet<String>();
        while (matcher.find()) {
            String match = matcher.group(1);
            tableNames.add(StringUtil.toLowerCase((String)match));
        }
        this._portalTableNames = tableNames;
        return tableNames;
    }

    protected boolean isPortalTableName(String tableName) throws Exception {
        Set<String> portalTableNames = this.getPortalTableNames();
        return portalTableNames.contains(StringUtil.toLowerCase((String)tableName));
    }
}

