/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.impl.ResourcePermissionLocalServiceImpl;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;

public class VerifyPermission
extends VerifyProcess {
    private static final Object[][] _ORGANIZATION_ACTION_IDS_TO_MASKS = new Object[][]{{"APPROVE_PROPOSAL", 2L, 0L}, {"ASSIGN_MEMBERS", 4L, 4L}, {"ASSIGN_REVIEWER", 8L, 0L}, {"MANAGE_ARCHIVED_SETUPS", 128L, 128L}, {"MANAGE_LAYOUTS", 256L, 256L}, {"MANAGE_STAGING", 512L, 512L}, {"MANAGE_TEAMS", 2048L, 1024L}, {"PUBLISH_STAGING", 16384L, 4096L}};
    private static Log _log = LogFactoryUtil.getLog(VerifyPermission.class);

    protected void checkPermissions() throws Exception {
        List modelNames = ResourceActionsUtil.getModelNames();
        for (String modelName : modelNames) {
            List actionIds = ResourceActionsUtil.getModelResourceActions((String)modelName);
            ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, (List)actionIds, (boolean)true);
        }
        List portletNames = ResourceActionsUtil.getPortletNames();
        for (String portletName : portletNames) {
            List actionIds = ResourceActionsUtil.getPortletResourceActions((String)portletName);
            ResourceActionLocalServiceUtil.checkResourceActions((String)portletName, (List)actionIds, (boolean)true);
        }
    }

    protected void deleteDefaultPrivateLayoutPermissions() throws Exception {
        long[] companyIds;
        for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
            try {
                this.deleteDefaultPrivateLayoutPermissions_6(companyId);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    protected void deleteDefaultPrivateLayoutPermissions_6(long companyId) throws Exception {
        Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
        List resourcePermissions = ResourcePermissionLocalServiceUtil.getRoleResourcePermissions((long)role.getRoleId());
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!this.isPrivateLayout(resourcePermission.getName(), resourcePermission.getPrimKey())) continue;
            ResourcePermissionLocalServiceUtil.deleteResourcePermission((long)resourcePermission.getResourcePermissionId());
        }
    }

    @Override
    protected void doVerify() throws Exception {
        this.deleteDefaultPrivateLayoutPermissions();
        this.checkPermissions();
        this.fixDockbarPermissions();
        this.fixOrganizationRolePermissions();
    }

    protected void fixDockbarPermissions() throws Exception {
        long[] companyIds;
        for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
            try {
                Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"User");
                ResourcePermissionLocalServiceUtil.addResourcePermission((long)companyId, (String)"145", (int)1, (String)String.valueOf(role.getCompanyId()), (long)role.getRoleId(), (String)"VIEW");
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    protected void fixOrganizationRolePermissions() throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(ResourcePermission.class);
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"name", (Object)Organization.class.getName()));
        List resourcePermissions = ResourcePermissionLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            ResourcePermission groupResourcePermission = null;
            try {
                groupResourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId());
            }
            catch (Exception e) {
                ResourcePermissionLocalServiceUtil.setResourcePermissions((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId(), (String[])ResourcePermissionLocalServiceImpl.EMPTY_ACTION_IDS);
                groupResourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId());
            }
            long organizationActions = resourcePermission.getActionIds();
            long groupActions = groupResourcePermission.getActionIds();
            for (Object[] actionIdToMask : _ORGANIZATION_ACTION_IDS_TO_MASKS) {
                long organizationActionMask = (Long)actionIdToMask[1];
                long groupActionMask = (Long)actionIdToMask[2];
                if ((organizationActions & organizationActionMask) != organizationActionMask) continue;
                organizationActions &= organizationActionMask ^ 0xFFFFFFFFFFFFFFFFL;
                groupActions |= groupActionMask;
            }
            try {
                resourcePermission.resetOriginalValues();
                resourcePermission.setActionIds(organizationActions);
                ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)resourcePermission);
                groupResourcePermission.resetOriginalValues();
                groupResourcePermission.setActionIds(groupActions);
                ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)groupResourcePermission);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        PermissionCacheUtil.clearCache();
    }

    protected boolean isPrivateLayout(String name, String primKey) throws Exception {
        if (!name.equals(Layout.class.getName())) {
            return false;
        }
        long plid = GetterUtil.getLong((String)primKey);
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        return !layout.isPublicLayout() && !layout.isTypeControlPanel();
    }
}

