/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import java.util.List;

public class VerifyOrganization
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyOrganization.class);

    @Override
    protected void doVerify() throws Exception {
        this.rebuildTree();
        this.updateOrganizationAssets();
        this.updateOrganizationAssetEntries();
    }

    protected void rebuildTree() throws Exception {
        long[] companyIds;
        for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
            OrganizationLocalServiceUtil.rebuildTree((long)companyId);
        }
    }

    protected void updateOrganizationAssetEntries() throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = OrganizationLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) {
                block3: {
                    Organization organization = (Organization)object;
                    try {
                        AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((String)Organization.class.getName(), (long)organization.getOrganizationId());
                        if (Validator.isNotNull((String)assetEntry.getClassUuid())) {
                            return;
                        }
                        assetEntry.setClassUuid(organization.getUuid());
                        AssetEntryLocalServiceUtil.updateAssetEntry((AssetEntry)assetEntry);
                    }
                    catch (Exception e) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn((Object)("Unable to update asset entry for organization " + organization.getOrganizationId()), (Throwable)e);
                    }
                }
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void updateOrganizationAssets() throws Exception {
        List organizations = OrganizationLocalServiceUtil.getNoAssetOrganizations();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + organizations.size() + " organizations with " + "no asset"));
        }
        for (Organization organization : organizations) {
            try {
                OrganizationLocalServiceUtil.updateAsset((long)organization.getUserId(), (Organization)organization, null, null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for organization " + organization.getOrganizationId() + ": " + e.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for organizations");
        }
    }
}

