/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutFriendlyURL;
import com.liferay.portal.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;

public class VerifyLayout
extends VerifyProcess {
    protected void deleteOrphanedLayouts() throws Exception {
        this.runSQL("delete from Layout where layoutPrototypeUuid != '' and layoutPrototypeUuid not in (select uuid_ from LayoutPrototype)");
    }

    @Override
    protected void doVerify() throws Exception {
        this.deleteOrphanedLayouts();
        this.verifyFriendlyURL();
        this.verifyLayoutPrototypeLinkEnabled();
        this.verifyUuid();
    }

    protected void verifyFriendlyURL() throws Exception {
        List layouts = LayoutLocalServiceUtil.getNullFriendlyURLLayouts();
        for (Layout layout : layouts) {
            List layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs((long)layout.getPlid());
            for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
                String friendlyURL = "/" + layout.getLayoutId();
                LayoutLocalServiceUtil.updateFriendlyURL((long)layout.getUserId(), (long)layout.getPlid(), (String)friendlyURL, (String)layoutFriendlyURL.getLanguageId());
            }
        }
    }

    protected void verifyLayoutPrototypeLinkEnabled() throws Exception {
        this.runSQL("update Layout set layoutPrototypeLinkEnabled = [$FALSE$] where type_ = 'link_to_layout' and layoutPrototypeLinkEnabled = [$TRUE$]");
    }

    protected void verifyUuid() throws Exception {
        this.verifyUuid("AssetEntry");
        this.verifyUuid("JournalArticle");
        this.runSQL("update Layout set uuid_ = sourcePrototypeLayoutUuid where sourcePrototypeLayoutUuid != '' and uuid_ != sourcePrototypeLayoutUuid");
    }

    protected void verifyUuid(String tableName) throws Exception {
        StringBundler sb = new StringBundler(12);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set layoutUuid = (select distinct ");
        sb.append("sourcePrototypeLayoutUuid from Layout where ");
        sb.append("Layout.uuid_ = ");
        sb.append(tableName);
        sb.append(".layoutUuid) where exists (select 1 from Layout where ");
        sb.append("Layout.uuid_ = ");
        sb.append(tableName);
        sb.append(".layoutUuid and Layout.uuid_ != ");
        sb.append("Layout.sourcePrototypeLayoutUuid and ");
        sb.append("Layout.sourcePrototypeLayoutUuid != '')");
        this.runSQL(sb.toString());
    }
}

