/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portal.verify.model.VerifiableGroupedModel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class VerifyGroupedModel
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyGroupedModel.class);

    public void verify(VerifiableGroupedModel ... verifiableGroupedModels) throws Exception {
        ArrayList<String> unverifiedTableNames = new ArrayList<String>();
        for (VerifiableGroupedModel verifiableGroupedModel : verifiableGroupedModels) {
            unverifiedTableNames.add(verifiableGroupedModel.getTableName());
        }
        while (!unverifiedTableNames.isEmpty()) {
            int count = unverifiedTableNames.size();
            for (VerifiableGroupedModel verifiableGroupedModel : verifiableGroupedModels) {
                if (unverifiedTableNames.contains(verifiableGroupedModel.getRelatedTableName()) || !unverifiedTableNames.contains(verifiableGroupedModel.getTableName())) continue;
                this.verifyGroupedModel(verifiableGroupedModel);
                unverifiedTableNames.remove(verifiableGroupedModel.getTableName());
            }
            if (unverifiedTableNames.size() != count) continue;
            throw new VerifyException("Circular dependency detected " + unverifiedTableNames);
        }
    }

    @Override
    protected void doVerify() throws Exception {
        Map verifiableGroupedModelsMap = PortalBeanLocatorUtil.locate(VerifiableGroupedModel.class);
        Collection verifiableGroupedModels = verifiableGroupedModelsMap.values();
        this.verify(verifiableGroupedModels.toArray(new VerifiableGroupedModel[verifiableGroupedModels.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getGroupId(String tableName, String primaryKeColumnName, long primKey) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block4: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select groupId from " + tableName + " where " + primaryKeColumnName + " = ?");
                ps.setLong(1, primKey);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                l = rs.getLong("groupId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unable to find " + tableName + " " + primKey));
        }
        long l = 0L;
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyGroupedModel(VerifiableGroupedModel verifiableGroupedModel) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(7);
            sb.append("select ");
            sb.append(verifiableGroupedModel.getPrimaryKeyColumnName());
            sb.append(", ");
            sb.append(verifiableGroupedModel.getRelatedPrimaryKeyColumnName());
            sb.append(" from ");
            sb.append(verifiableGroupedModel.getTableName());
            sb.append(" where groupId is null");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                long primKey = rs.getLong(verifiableGroupedModel.getPrimaryKeyColumnName());
                long relatedPrimKey = rs.getLong(verifiableGroupedModel.getRelatedPrimaryKeyColumnName());
                long groupId = this.getGroupId(verifiableGroupedModel.getRelatedTableName(), verifiableGroupedModel.getRelatedPrimaryKeyColumnName(), relatedPrimKey);
                if (groupId <= 0L) continue;
                sb = new StringBundler(8);
                sb.append("update ");
                sb.append(verifiableGroupedModel.getTableName());
                sb.append(" set groupId = ");
                sb.append(groupId);
                sb.append(" where ");
                sb.append(verifiableGroupedModel.getPrimaryKeyColumnName());
                sb.append(" = ");
                sb.append(primKey);
                this.runSQL(sb.toString());
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

