/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordModel;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMForm;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormField;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructureLink;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLinkLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VerifyDynamicDataMapping
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyDynamicDataMapping.class);
    private long _ddlRecordSetClassNameId;
    private long _ddmStructureClassNameId;
    private long _dlFileEntryMetadataClassNameId;

    protected FileEntry addFileEntry(long companyId, long userId, long groupId, long folderId, String fileName, String filePath, int status) throws Exception {
        String contentType = MimeTypesUtil.getContentType((String)fileName);
        String title = fileName;
        int index = title.indexOf(46);
        if (index > 0) {
            title = title.substring(0, index);
        }
        try {
            File file = DLStoreUtil.getFile((long)companyId, (long)0L, (String)filePath);
            ServiceContext serviceContext = this.createServiceContext();
            FileEntry fileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)groupId, (long)folderId, (String)fileName, (String)contentType, (String)title, (String)"", (String)"", (File)file, (ServiceContext)serviceContext);
            this.updateFileEntryStatus(fileEntry, status, serviceContext);
            return fileEntry;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to add file entry " + fileName), (Throwable)e);
            }
            return null;
        }
    }

    protected Folder addFolder(long userId, long groupId, long primaryKey, String fieldName) throws Exception {
        Folder ddmFolder = this.addFolder(userId, groupId, 0L, "DDM", "");
        Folder primaryKeyFolder = this.addFolder(userId, groupId, ddmFolder.getFolderId(), String.valueOf(primaryKey), "");
        return this.addFolder(userId, groupId, primaryKeyFolder.getFolderId(), fieldName, "");
    }

    protected Folder addFolder(long userId, long groupId, long parentFolderId, String name, String description) throws Exception {
        try {
            return DLAppLocalServiceUtil.getFolder((long)groupId, (long)parentFolderId, (String)name);
        }
        catch (NoSuchFolderException nsfe) {
            return DLAppLocalServiceUtil.addFolder((long)userId, (long)groupId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)this.createServiceContext());
        }
    }

    protected ServiceContext createServiceContext() {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return serviceContext;
    }

    @Override
    protected void doVerify() throws Exception {
        this.setUpClassNameIds();
        List ddmStructures = DDMStructureLocalServiceUtil.getStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            this.verifyDDMStructure(ddmStructure);
            this.verifyDDMTemplates(ddmStructure);
            this.updateFileUploadReferences(ddmStructure);
        }
    }

    protected List<Node> getDynamicElementNodes(Document document) {
        XPath xPathSelector = SAXReaderUtil.createXPath((String)"//dynamic-element");
        return xPathSelector.selectNodes((Object)document);
    }

    protected String getFileUploadPath(BaseModel<?> baseModel) throws Exception {
        StringBundler sb = new StringBundler(7);
        long primaryKey = 0L;
        String version = "";
        if (baseModel instanceof DDLRecordModel) {
            DDLRecord ddlRecord = (DDLRecord)baseModel;
            primaryKey = ddlRecord.getPrimaryKey();
            DDLRecordVersion ddlRecordVersion = ddlRecord.getRecordVersion();
            version = ddlRecordVersion.getVersion();
        } else {
            DLFileEntryMetadata dlFileEntryMetadata = (DLFileEntryMetadata)baseModel;
            primaryKey = dlFileEntryMetadata.getPrimaryKey();
            DLFileVersion dlFileVersion = dlFileEntryMetadata.getFileVersion();
            version = dlFileVersion.getVersion();
        }
        sb.append("ddm");
        sb.append("/");
        sb.append(baseModel.getModelClassName());
        sb.append("/");
        sb.append(primaryKey);
        sb.append("/");
        sb.append(version);
        return sb.toString();
    }

    protected List<DDMTemplate> getFormDDMTemplates(DDMStructure ddmStructure) throws Exception {
        return DDMTemplateLocalServiceUtil.getTemplates((long)ddmStructure.getGroupId(), (long)this._ddmStructureClassNameId, (long)ddmStructure.getStructureId(), (String)"form");
    }

    protected String getJSON(FileEntry fileEntry) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("groupId", fileEntry.getGroupId());
        jsonObject.put("uuid", fileEntry.getUuid());
        return jsonObject.toString();
    }

    protected boolean hasDefaultMetadataElement(Element dynamicElementElement, String defaultLanguageId) {
        List metadataElements = dynamicElementElement.elements("meta-data");
        for (Element metadataElement : metadataElements) {
            String languageId = metadataElement.attributeValue("locale");
            if (!languageId.equals(defaultLanguageId)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasFileUploadFields(DDMStructure ddmStructure) throws Exception {
        Map ddmFormFieldsMap = ddmStructure.getFullHierarchyDDMFormFieldsMap(true);
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            String dataType = ddmFormField.getDataType();
            if (!Validator.equals((Object)dataType, (Object)"file-upload")) continue;
            return true;
        }
        return false;
    }

    protected void setUpClassNameIds() {
        this._ddlRecordSetClassNameId = PortalUtil.getClassNameId(DDLRecordSet.class);
        this._ddmStructureClassNameId = PortalUtil.getClassNameId(DDMStructure.class);
        this._dlFileEntryMetadataClassNameId = PortalUtil.getClassNameId(DLFileEntryMetadata.class);
    }

    protected void updateDDLFileUploadReferences(long ddlRecordSetId) throws Exception {
        List ddlRecords = DDLRecordLocalServiceUtil.getRecords((long)ddlRecordSetId);
        for (DDLRecord ddlRecord : ddlRecords) {
            this.updateFileUploadReferences(ddlRecord.getCompanyId(), ddlRecord.getDDMStorageId(), ddlRecord.getUserId(), ddlRecord.getGroupId(), (BaseModel<?>)ddlRecord, ddlRecord.getStatus());
        }
    }

    protected void updateDDMStructure(DDMStructure ddmStructure, DDMForm ddmForm) throws Exception {
        ddmStructure.updateDDMForm(ddmForm);
        DDMStructureLocalServiceUtil.updateDDMStructure((DDMStructure)ddmStructure);
    }

    protected void updateDDMTemplate(DDMTemplate template, String script) throws Exception {
        if (script.equals(template.getScript())) {
            return;
        }
        template.setScript(script);
        DDMTemplateLocalServiceUtil.updateDDMTemplate((DDMTemplate)template);
    }

    protected void updateDLFileUploadReferences(long dlFileEntryMetadataId) throws Exception {
        DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.getFileEntryMetadata((long)dlFileEntryMetadataId);
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntryMetadata.getFileEntryId());
        FileVersion fileVersion = fileEntry.getFileVersion();
        this.updateFileUploadReferences(fileEntry.getCompanyId(), dlFileEntryMetadata.getDDMStorageId(), fileEntry.getUserId(), fileEntry.getGroupId(), (BaseModel<?>)dlFileEntryMetadata, fileVersion.getStatus());
    }

    protected void updateFieldValues(long storageId, Map<String, String> fieldValues) throws Exception {
        Fields fields = new Fields();
        for (Map.Entry<String, String> entry : fieldValues.entrySet()) {
            Field field = new Field(storageId, entry.getKey(), (Serializable)((Object)entry.getValue()));
            fields.put(field);
        }
        ServiceContext serviceContext = new ServiceContext();
        StorageEngineUtil.update((long)storageId, (Fields)fields, (boolean)true, (ServiceContext)serviceContext);
    }

    protected void updateFileEntryStatus(FileEntry fileEntry, int status, ServiceContext serviceContext) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        workflowContext.put("event", "add");
        DLFileEntryLocalServiceUtil.updateStatus((long)fileVersion.getUserId(), (long)fileVersion.getFileVersionId(), (int)status, (ServiceContext)serviceContext, workflowContext);
    }

    protected void updateFileUploadReferences(DDMForm ddmForm) throws Exception {
        List ddmFormFields = ddmForm.getDDMFormFields();
        for (DDMFormField ddmFormField : ddmFormFields) {
            this.updateFileUploadReferences(ddmFormField);
        }
    }

    protected void updateFileUploadReferences(DDMFormField ddmFormField) {
        String dataType = ddmFormField.getDataType();
        if (Validator.equals((Object)dataType, (Object)"file-upload")) {
            ddmFormField.setDataType("document-library");
            ddmFormField.setType("ddm-documentlibrary");
        }
    }

    protected void updateFileUploadReferences(DDMStructure ddmStructure) throws Exception {
        if (!this.hasFileUploadFields(ddmStructure)) {
            return;
        }
        List ddmStructureLinks = DDMStructureLinkLocalServiceUtil.getStructureLinks((long)ddmStructure.getStructureId(), (int)-1, (int)-1);
        for (DDMStructureLink ddmStructureLink : ddmStructureLinks) {
            this.updateFileUploadReferences(ddmStructureLink);
        }
        DDMForm ddmForm = ddmStructure.getDDMForm();
        this.updateFileUploadReferences(ddmForm);
        this.updateDDMStructure(ddmStructure, ddmForm);
        List<DDMTemplate> ddmTemplates = this.getFormDDMTemplates(ddmStructure);
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            String script = this.updateFileUploadReferences(ddmTemplate.getScript());
            this.updateDDMTemplate(ddmTemplate, script);
        }
    }

    protected void updateFileUploadReferences(DDMStructureLink ddmStructureLink) throws Exception {
        long classNameId = ddmStructureLink.getClassNameId();
        if (classNameId == this._ddlRecordSetClassNameId) {
            this.updateDDLFileUploadReferences(ddmStructureLink.getClassPK());
        } else if (classNameId == this._dlFileEntryMetadataClassNameId) {
            this.updateDLFileUploadReferences(ddmStructureLink.getClassPK());
        }
    }

    protected void updateFileUploadReferences(Element dynamicElementElement) {
        String dataType = dynamicElementElement.attributeValue("dataType");
        if (Validator.equals((Object)dataType, (Object)"file-upload")) {
            dynamicElementElement.addAttribute("dataType", "document-library");
            dynamicElementElement.addAttribute("type", "ddm-documentlibrary");
        }
    }

    protected void updateFileUploadReferences(long companyId, long storageId, long userId, long groupId, BaseModel<?> baseModel, int status) throws Exception {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Fields fields = StorageEngineUtil.getFields((long)storageId);
        for (Field field : fields) {
            String dataType = field.getDataType();
            if (!dataType.equals("file-upload") || Validator.isNull((Object)field.getValue())) continue;
            long primaryKey = GetterUtil.getLong((Object)baseModel.getPrimaryKeyObj());
            Folder folder = this.addFolder(userId, groupId, primaryKey, field.getName());
            String valueString = String.valueOf(field.getValue());
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            String filePath = this.getFileUploadPath(baseModel) + "/" + field.getName();
            FileEntry fileEntry = this.addFileEntry(companyId, userId, groupId, folder.getFolderId(), jsonObject.getString("name"), filePath, status);
            if (fileEntry == null) continue;
            fieldValues.put(field.getName(), this.getJSON(fileEntry));
        }
        this.updateFieldValues(storageId, fieldValues);
    }

    protected String updateFileUploadReferences(String xsd) throws Exception {
        Document document = SAXReaderUtil.read((String)xsd);
        List<Node> nodes = this.getDynamicElementNodes(document);
        for (Node node : nodes) {
            Element dynamicElementElement = (Element)node;
            this.updateFileUploadReferences(dynamicElementElement);
        }
        return DDMXMLUtil.formatXML((String)document.asXML());
    }

    protected DDMForm verifyDDMForm(DDMForm ddmForm) {
        List ddmFormFields = ddmForm.getDDMFormFields();
        for (DDMFormField ddmFormField : ddmFormFields) {
            this.verifyDDMFormField(ddmFormField);
        }
        return ddmForm;
    }

    protected void verifyDDMFormField(DDMFormField ddmFormField) {
        String dataType = ddmFormField.getDataType();
        if (Validator.equals((Object)dataType, (Object)"image")) {
            ddmFormField.setNamespace("ddm");
            ddmFormField.setType("ddm-image");
        }
    }

    protected void verifyDDMStructure(DDMStructure ddmStructure) throws Exception {
        DDMForm ddmForm = this.verifyDDMForm(ddmStructure.getDDMForm());
        this.updateDDMStructure(ddmStructure, ddmForm);
    }

    protected void verifyDDMTemplate(DDMTemplate ddmTemplate) throws Exception {
        if (ddmTemplate.getType() != "form") {
            return;
        }
        String script = this.verifySchema(ddmTemplate.getScript(), ddmTemplate.getDefaultLanguageId());
        this.updateDDMTemplate(ddmTemplate, script);
    }

    protected void verifyDDMTemplates(DDMStructure ddmStructure) throws Exception {
        List<DDMTemplate> ddmTemplates = this.getFormDDMTemplates(ddmStructure);
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            this.verifyDDMTemplate(ddmTemplate);
        }
    }

    protected void verifyDynamicElement(Element dynamicElementElement, String defaultLanguageId) {
        String dataType = dynamicElementElement.attributeValue("dataType");
        if (Validator.equals((Object)dataType, (Object)"image")) {
            dynamicElementElement.addAttribute("fieldNamespace", "ddm");
            dynamicElementElement.addAttribute("type", "ddm-image");
        }
        this.verifyMetadataElement(dynamicElementElement, defaultLanguageId);
    }

    protected void verifyMetadataElement(Element dynamicElementElement, String defaultLanguageId) {
        boolean hasDefaultMetadataElement = this.hasDefaultMetadataElement(dynamicElementElement, defaultLanguageId);
        if (hasDefaultMetadataElement) {
            return;
        }
        Element metadataElement = dynamicElementElement.addElement("meta-data");
        metadataElement.addAttribute("locale", defaultLanguageId);
        Element entryElement = metadataElement.addElement("entry");
        entryElement.addAttribute("name", "label");
        entryElement.addCDATA("");
    }

    protected String verifySchema(String xsd, String defaultLanguageId) throws Exception {
        Document document = SAXReaderUtil.read((String)xsd);
        List<Node> nodes = this.getDynamicElementNodes(document);
        for (Node node : nodes) {
            Element dynamicElementElement = (Element)node;
            this.verifyDynamicElement(dynamicElementElement, defaultLanguageId);
        }
        return DDMXMLUtil.formatXML((String)document.asXML());
    }
}

