/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import java.util.List;

public class VerifyBookmarks
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyBookmarks.class);

    @Override
    protected void doVerify() throws Exception {
        this.updateEntryAssets();
        this.updateFolderAssets();
        this.verifyTree();
    }

    protected void updateEntryAssets() throws Exception {
        List entries = BookmarksEntryLocalServiceUtil.getNoAssetEntries();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + entries.size() + " entries with no asset"));
        }
        for (BookmarksEntry entry : entries) {
            try {
                BookmarksEntryLocalServiceUtil.updateAsset((long)entry.getUserId(), (BookmarksEntry)entry, null, null, null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for entry " + entry.getEntryId() + ": " + e.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for entries");
        }
    }

    protected void updateFolderAssets() throws Exception {
        List folders = BookmarksFolderLocalServiceUtil.getNoAssetFolders();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + folders.size() + " folders with no asset"));
        }
        for (BookmarksFolder folder : folders) {
            try {
                BookmarksFolderLocalServiceUtil.updateAsset((long)folder.getUserId(), (BookmarksFolder)folder, null, null, null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for folder " + folder.getFolderId() + ": " + e.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for folders");
        }
    }

    protected void verifyTree() throws Exception {
        long[] companyIds;
        for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
            BookmarksFolderLocalServiceUtil.rebuildTree((long)companyId);
        }
    }
}

