/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portal.verify.model.VerifiableAuditedModel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class VerifyAuditedModel
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyAuditedModel.class);

    public void verify(VerifiableAuditedModel ... verifiableAuditedModels) throws Exception {
        ArrayList<String> unverifiedTableNames = new ArrayList<String>();
        for (VerifiableAuditedModel verifiableAuditedModel : verifiableAuditedModels) {
            unverifiedTableNames.add(verifiableAuditedModel.getTableName());
        }
        while (!unverifiedTableNames.isEmpty()) {
            int count = unverifiedTableNames.size();
            for (VerifiableAuditedModel verifiableAuditedModel : verifiableAuditedModels) {
                if (unverifiedTableNames.contains(verifiableAuditedModel.getJoinByTableName()) || !unverifiedTableNames.contains(verifiableAuditedModel.getTableName())) continue;
                this.verifyAuditedModel(verifiableAuditedModel);
                unverifiedTableNames.remove(verifiableAuditedModel.getTableName());
            }
            if (unverifiedTableNames.size() != count) continue;
            throw new VerifyException("Circular dependency detected " + unverifiedTableNames);
        }
    }

    @Override
    protected void doVerify() throws Exception {
        Map verifiableAuditedModelsMap = PortalBeanLocatorUtil.locate(VerifiableAuditedModel.class);
        Collection verifiableAuditedModels = verifiableAuditedModelsMap.values();
        this.verify(verifiableAuditedModels.toArray(new VerifiableAuditedModel[verifiableAuditedModels.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getAuditedModelArray(String tableName, String pkColumnName, long primKey) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block4: {
            Object[] objectArray;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select companyId, userId, createDate, modifiedDate from " + tableName + " where " + pkColumnName + " = ?");
                ps.setLong(1, primKey);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                Timestamp createDate = rs.getTimestamp("createDate");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                objectArray = new Object[]{companyId, userId, this.getUserName(userId), createDate, modifiedDate};
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return objectArray;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unable to find " + tableName + " " + primKey));
        }
        Object[] objectArray = null;
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getDefaultUserArray(Connection con, long companyId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            Object[] objectArray;
            ps = null;
            rs = null;
            try {
                ps = con.prepareStatement("select userId, firstName, middleName, lastName from User_ where companyId = ? and defaultUser = ?");
                ps.setLong(1, companyId);
                ps.setBoolean(2, true);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                long userId = rs.getLong("userId");
                String firstName = rs.getString("firstName");
                String middleName = rs.getString("middleName");
                String lastName = rs.getString("lastName");
                FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
                String userName = fullNameGenerator.getFullName(firstName, middleName, lastName);
                Timestamp createDate = new Timestamp(System.currentTimeMillis());
                objectArray = new Object[]{companyId, userId, userName, createDate, createDate};
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp(null, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp(null, (Statement)ps, (ResultSet)rs);
            return objectArray;
        }
        Object[] objectArray = null;
        DataAccess.cleanUp(null, (Statement)ps, (ResultSet)rs);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUserName(long userId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block3: {
            String string;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select firstName, middleName, lastName from User_ where userId = ?");
                ps.setLong(1, userId);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                String firstName = rs.getString("firstName");
                String middleName = rs.getString("middleName");
                String lastName = rs.getString("lastName");
                FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
                string = fullNameGenerator.getFullName(firstName, middleName, lastName);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return string;
        }
        String string = "";
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyAuditedModel(String tableName, String primaryKeyColumnName, long primKey, Object[] auditedModelArray, boolean updateDates) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            long companyId = (Long)auditedModelArray[0];
            if (auditedModelArray[2] == null && (auditedModelArray = this.getDefaultUserArray(con, companyId)) == null) {
                return;
            }
            long userId = (Long)auditedModelArray[1];
            String userName = (String)auditedModelArray[2];
            Timestamp createDate = (Timestamp)auditedModelArray[3];
            Timestamp modifiedDate = (Timestamp)auditedModelArray[4];
            StringBundler sb = new StringBundler(7);
            sb.append("update ");
            sb.append(tableName);
            sb.append(" set companyId = ?, userId = ?, userName = ?");
            if (updateDates) {
                sb.append(", createDate = ?, modifiedDate = ?");
            }
            sb.append(" where ");
            sb.append(primaryKeyColumnName);
            sb.append(" = ?");
            ps = con.prepareStatement(sb.toString());
            ps.setLong(1, companyId);
            ps.setLong(2, userId);
            ps.setString(3, userName);
            if (updateDates) {
                ps.setTimestamp(4, createDate);
                ps.setTimestamp(5, modifiedDate);
                ps.setLong(6, primKey);
            } else {
                ps.setLong(4, primKey);
            }
            ps.executeUpdate();
            DataAccess.cleanUp((Connection)con, (Statement)ps);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to verify model " + tableName), (Throwable)e);
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyAuditedModel(VerifiableAuditedModel verifiableAuditedModel) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(8);
            sb.append("select ");
            sb.append(verifiableAuditedModel.getPrimaryKeyColumnName());
            sb.append(", companyId");
            if (verifiableAuditedModel.getJoinByTableName() != null) {
                sb.append(", ");
                sb.append(verifiableAuditedModel.getJoinByTableName());
            }
            sb.append(" from ");
            sb.append(verifiableAuditedModel.getTableName());
            sb.append(" where userName is null order by companyId");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            Object[] auditedModelArray = null;
            long previousCompanyId = 0L;
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                long primKey = rs.getLong(verifiableAuditedModel.getPrimaryKeyColumnName());
                if (verifiableAuditedModel.getJoinByTableName() != null) {
                    long relatedPrimKey = rs.getLong(verifiableAuditedModel.getJoinByTableName());
                    auditedModelArray = this.getAuditedModelArray(verifiableAuditedModel.getRelatedModelName(), verifiableAuditedModel.getRelatedPKColumnName(), relatedPrimKey);
                } else if (previousCompanyId != companyId) {
                    auditedModelArray = this.getDefaultUserArray(con, companyId);
                    previousCompanyId = companyId;
                }
                if (auditedModelArray == null) continue;
                this.verifyAuditedModel(verifiableAuditedModel.getTableName(), verifiableAuditedModel.getPrimaryKeyColumnName(), primKey, auditedModelArray, verifiableAuditedModel.isUpdateDates());
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

