/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Theme;
import com.liferay.portal.service.permission.RolePermissionUtil;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.TemplatePortletPreferences;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.IteratorTool;
import org.apache.velocity.tools.generic.ListTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.SortTool;

public class VelocityTemplateContextHelper
extends TemplateContextHelper {
    private static Log _log = LogFactoryUtil.getLog(VelocityTemplateContextHelper.class);

    @Override
    public Set<String> getRestrictedVariables() {
        return SetUtil.fromArray((Object[])PropsValues.VELOCITY_ENGINE_RESTRICTED_VARIABLES);
    }

    @Override
    public void prepare(Template template, HttpServletRequest request) {
        Map vmVariables;
        Theme theme;
        super.prepare(template, request);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            template.put("init", (Object)(themeDisplay.getPathContext() + "_SERVLET_CONTEXT_" + "/html/themes/_unstyled/templates/init.vm"));
        }
        if ((theme = (Theme)request.getAttribute("THEME")) == null && themeDisplay != null) {
            theme = themeDisplay.getTheme();
        }
        if (theme != null) {
            String servletContextName = GetterUtil.getString((String)theme.getServletContextName());
            template.put("fullCssPath", (Object)(servletContextName + theme.getVelocityResourceListener() + theme.getCssPath()));
            template.put("fullTemplatesPath", (Object)(servletContextName + theme.getVelocityResourceListener() + theme.getTemplatesPath()));
        }
        if ((vmVariables = (Map)request.getAttribute("VM_VARIABLES")) != null) {
            for (Map.Entry entry : vmVariables.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (!Validator.isNotNull((String)key)) continue;
                template.put(key, value);
            }
        }
    }

    @Override
    protected void populateExtraHelperUtilities(Map<String, Object> velocityContext) {
        velocityContext.put("dateTool", new DateTool());
        velocityContext.put("escapeTool", new EscapeTool());
        velocityContext.put("iteratorTool", new IteratorTool());
        velocityContext.put("listTool", new ListTool());
        velocityContext.put("mathTool", new MathTool());
        velocityContext.put("numberTool", new NumberTool());
        velocityContext.put("velocityPortletPreferences", new TemplatePortletPreferences());
        velocityContext.put("sortTool", new SortTool());
        try {
            velocityContext.put("rolePermission", RolePermissionUtil.getRolePermission());
        }
        catch (SecurityException se) {
            _log.error((Object)se, (Throwable)se);
        }
    }
}

