/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.template.AbstractTemplate;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.TemplateResourceThreadLocal;
import com.liferay.portal.util.PropsValues;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;

public class VelocityTemplate
extends AbstractTemplate {
    private boolean _privileged;
    private VelocityContext _velocityContext;
    private VelocityEngine _velocityEngine;

    public VelocityTemplate(TemplateResource templateResource, TemplateResource errorTemplateResource, Map<String, Object> context, VelocityEngine velocityEngine, TemplateContextHelper templateContextHelper, boolean privileged) {
        super(templateResource, errorTemplateResource, context, templateContextHelper, "vm", PropsValues.VELOCITY_ENGINE_RESOURCE_MODIFICATION_CHECK_INTERVAL);
        this._velocityContext = new VelocityContext(this.context);
        this._velocityEngine = velocityEngine;
        this._privileged = privileged;
    }

    @Override
    protected void handleException(Exception exception, Writer writer) throws TemplateException {
        this.put("exception", exception.getMessage());
        if (this.templateResource instanceof StringTemplateResource) {
            StringTemplateResource stringTemplateResource = (StringTemplateResource)this.templateResource;
            this.put("script", stringTemplateResource.getContent());
        }
        if (exception instanceof ParseErrorException) {
            ParseErrorException pee = (ParseErrorException)exception;
            this.put("column", pee.getColumnNumber());
            this.put("line", pee.getLineNumber());
        }
        try {
            this.processTemplate(this.errorTemplateResource, writer);
        }
        catch (Exception e) {
            throw new TemplateException("Unable to process Velocity template " + this.errorTemplateResource.getTemplateId(), (Throwable)e);
        }
    }

    @Override
    protected void processTemplate(TemplateResource templateResource, Writer writer) throws Exception {
        TemplateResourceThreadLocal.setTemplateResource("vm", templateResource);
        try {
            Template template = null;
            template = this._privileged ? AccessController.doPrivileged(new TemplatePrivilegedExceptionAction(templateResource)) : this._velocityEngine.getTemplate(this.getTemplateResourceUUID(templateResource), "UTF-8");
            template.merge((Context)this._velocityContext, writer);
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        finally {
            TemplateResourceThreadLocal.setTemplateResource("vm", null);
        }
    }

    private class TemplatePrivilegedExceptionAction
    implements PrivilegedExceptionAction<Template> {
        private TemplateResource _templateResource;

        public TemplatePrivilegedExceptionAction(TemplateResource templateResource) {
            this._templateResource = templateResource;
        }

        @Override
        public Template run() throws Exception {
            return VelocityTemplate.this._velocityEngine.getTemplate(VelocityTemplate.this.getTemplateResourceUUID(this._templateResource), "UTF-8");
        }
    }
}

