/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.template.TemplateResourceThreadLocal;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.velocity.FastExtendedProperties;
import com.liferay.portal.velocity.LiferayResourceLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceManagerImpl;

public class LiferayResourceManager
extends ResourceManagerImpl {
    private PortalCache<TemplateResource, Object> _portalCache;

    public LiferayResourceManager() {
        String cacheName = TemplateResource.class.getName();
        cacheName = cacheName.concat("#").concat("vm");
        this._portalCache = SingleVMPoolUtil.getCache((String)cacheName);
    }

    public String getLoaderNameForResource(String source) {
        if (this.globalCache.get((Object)(2 + source)) != null || this.globalCache.get((Object)(1 + source)) != null) {
            return LiferayResourceLoader.class.getName();
        }
        return super.getLoaderNameForResource(source);
    }

    public Resource getResource(String resourceName, int resourceType, String encoding) throws Exception, ParseErrorException, ResourceNotFoundException {
        String[] macroTemplateIds;
        for (String macroTemplateId : macroTemplateIds = PropsUtil.getArray("velocity.engine.velocimacro.library")) {
            if (!resourceName.equals(macroTemplateId)) continue;
            try {
                return AccessController.doPrivileged(new ResourcePrivilegedExceptionAction(resourceName, resourceType, encoding));
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        }
        return this.doGetResource(resourceName, resourceType, encoding);
    }

    public synchronized void initialize(RuntimeServices runtimeServices) throws Exception {
        ExtendedProperties extendedProperties = runtimeServices.getConfiguration();
        Field field = ReflectionUtil.getDeclaredField(RuntimeInstance.class, (String)"configuration");
        field.set(runtimeServices, (Object)new FastExtendedProperties(extendedProperties));
        super.initialize(runtimeServices);
    }

    private Template _createTemplate(TemplateResource templateResource) throws IOException {
        LiferayTemplate template = new LiferayTemplate(templateResource.getReader());
        template.setEncoding("UTF-8");
        template.setName(templateResource.getTemplateId());
        template.setResourceLoader(new LiferayResourceLoader());
        template.setRuntimeServices(this.rsvc);
        template.process();
        return template;
    }

    private Resource doGetResource(String resourceName, int resourceType, String encoding) throws Exception, ParseErrorException, ResourceNotFoundException {
        if (resourceType != 1) {
            return super.getResource(resourceName, resourceType, encoding);
        }
        TemplateResource templateResource = null;
        templateResource = resourceName.startsWith("TEMPLATE_RESOURCE_UUID") ? TemplateResourceThreadLocal.getTemplateResource("vm") : TemplateResourceLoaderUtil.getTemplateResource((String)"vm", (String)resourceName);
        if (templateResource == null) {
            throw new ResourceNotFoundException("Unable to find Velocity template with ID " + resourceName);
        }
        Object object = this._portalCache.get((Serializable)templateResource);
        if (object != null && object instanceof Template) {
            return (Template)object;
        }
        Template template = this._createTemplate(templateResource);
        if (PropsValues.VELOCITY_ENGINE_RESOURCE_MODIFICATION_CHECK_INTERVAL != 0) {
            this._portalCache.put((Serializable)templateResource, (Object)template);
        }
        return template;
    }

    private class ResourcePrivilegedExceptionAction
    implements PrivilegedExceptionAction<Resource> {
        private String _encoding;
        private String _resourceName;
        private int _resourceType;

        public ResourcePrivilegedExceptionAction(String resourceName, int resourceType, String encoding) {
            this._resourceName = resourceName;
            this._resourceType = resourceType;
            this._encoding = encoding;
        }

        @Override
        public Resource run() throws Exception {
            return LiferayResourceManager.this.doGetResource(this._resourceName, this._resourceType, this._encoding);
        }
    }

    private class LiferayTemplate
    extends Template {
        private Reader _reader;

        public LiferayTemplate(Reader reader) {
            this._reader = reader;
        }

        public boolean process() throws IOException, ParseErrorException {
            this.data = null;
            try {
                this.data = this.rsvc.parse(this._reader, this.name);
                this.initDocument();
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw new ParseErrorException("Unable to parse Velocity template");
            }
            finally {
                if (this._reader != null) {
                    this._reader.close();
                }
            }
        }
    }
}

