/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.configuration.ConfigurationImpl;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.WebDirDetector;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;

public class PropsUtil {
    private static Log _log = LogFactoryUtil.getLog(PropsUtil.class);
    private static PropsUtil _instance = new PropsUtil();
    private final Configuration _configuration;
    private Map<Long, Configuration> _configurations;

    public static void addProperties(Properties properties) {
        _instance._addProperties(properties);
    }

    public static void addProperties(UnicodeProperties unicodeProperties) {
        _instance._addProperties(unicodeProperties);
    }

    public static boolean contains(String key) {
        return _instance._contains(key);
    }

    public static String get(String key) {
        return _instance._get(key);
    }

    public static String get(String key, Filter filter) {
        return _instance._get(key, filter);
    }

    public static String[] getArray(String key) {
        return _instance._getArray(key);
    }

    public static String[] getArray(String key, Filter filter) {
        return _instance._getArray(key, filter);
    }

    public static Properties getProperties() {
        return _instance._getProperties();
    }

    public static Properties getProperties(String prefix, boolean removePrefix) {
        return _instance._getProperties(prefix, removePrefix);
    }

    public static void reload() {
        _instance = new PropsUtil();
    }

    public static void removeProperties(Properties properties) {
        _instance._removeProperties(properties);
    }

    public static void set(String key, String value) {
        _instance._set(key, value);
    }

    private PropsUtil() {
        ConfigurationImpl configuration = null;
        try {
            SystemProperties.set((String)"default.liferay.home", (String)this._getDefaultLiferayHome());
            String globalSharedLibDir = this._getLibDir(Servlet.class);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Global shared lib directory " + globalSharedLibDir));
            }
            SystemProperties.set((String)"liferay.lib.global.shared.dir", (String)globalSharedLibDir);
            String globalLibDir = this._getLibDir(ReleaseInfo.class);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Global lib directory " + globalLibDir));
            }
            SystemProperties.set((String)"liferay.lib.global.dir", (String)globalLibDir);
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            String portalLibDir = WebDirDetector.getLibDir((ClassLoader)classLoader);
            String portalLibDirProperty = System.getProperty("liferay.lib.portal.dir");
            if (portalLibDirProperty != null) {
                if (!portalLibDirProperty.endsWith("/")) {
                    portalLibDirProperty = portalLibDirProperty + "/";
                }
                portalLibDir = portalLibDirProperty;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Portal lib directory " + portalLibDir));
            }
            SystemProperties.set((String)"liferay.lib.portal.dir", (String)portalLibDir);
            String portalWebDir = WebDirDetector.getRootDir((String)portalLibDir);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Portal web directory " + portalWebDir));
            }
            SystemProperties.set((String)"liferay.web.portal.dir", (String)portalWebDir);
            configuration = new ConfigurationImpl(PropsUtil.class.getClassLoader(), "portal");
        }
        catch (Exception e) {
            _log.error((Object)"Unable to initialize PropsUtil", (Throwable)e);
        }
        this._configuration = configuration;
        String liferayHome = this._get("liferay.home");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Configured Liferay home " + liferayHome));
        }
        SystemProperties.set((String)"liferay.home", (String)liferayHome);
        SystemProperties.set((String)"ehcache.disk.store.dir", (String)(liferayHome + "/data/ehcache"));
        if (GetterUtil.getBoolean((String)SystemProperties.get((String)"company-id-properties"))) {
            this._configurations = new HashMap<Long, Configuration>();
        }
    }

    private void _addProperties(Properties properties) {
        this._getConfiguration().addProperties(properties);
    }

    private void _addProperties(UnicodeProperties unicodeProperties) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)unicodeProperties);
        this._addProperties(properties);
    }

    private boolean _contains(String key) {
        return this._getConfiguration().contains(key);
    }

    private String _get(String key) {
        return this._getConfiguration().get(key);
    }

    private String _get(String key, Filter filter) {
        return this._getConfiguration().get(key, filter);
    }

    private String[] _getArray(String key) {
        return this._getConfiguration().getArray(key);
    }

    private String[] _getArray(String key, Filter filter) {
        return this._getConfiguration().getArray(key, filter);
    }

    private Configuration _getConfiguration() {
        if (this._configurations == null) {
            return this._configuration;
        }
        Long companyId = CompanyThreadLocal.getCompanyId();
        if (companyId > 0L) {
            Configuration configuration = this._configurations.get(companyId);
            if (configuration == null) {
                configuration = new ConfigurationImpl(PropsUtil.class.getClassLoader(), "portal", companyId);
                this._configurations.put(companyId, configuration);
            }
            return configuration;
        }
        return this._configuration;
    }

    private String _getDefaultLiferayHome() {
        int pos;
        String defaultLiferayHome = null;
        defaultLiferayHome = ServerDetector.isGeronimo() ? SystemProperties.get((String)"org.apache.geronimo.home.dir") + "/.." : (ServerDetector.isGlassfish() ? SystemProperties.get((String)"com.sun.aas.installRoot") + "/.." : (ServerDetector.isJBoss() ? SystemProperties.get((String)"jboss.home.dir") + "/.." : (ServerDetector.isJOnAS() ? SystemProperties.get((String)"jonas.base") + "/.." : (ServerDetector.isWebLogic() ? SystemProperties.get((String)"env.DOMAIN_HOME") + "/.." : (ServerDetector.isJetty() ? SystemProperties.get((String)"jetty.home") + "/.." : (ServerDetector.isResin() ? SystemProperties.get((String)"resin.home") + "/.." : (ServerDetector.isTomcat() ? SystemProperties.get((String)"catalina.base") + "/.." : SystemProperties.get((String)"user.dir") + "/liferay")))))));
        defaultLiferayHome = StringUtil.replace((String)defaultLiferayHome, (char)'\\', (char)'/');
        if ((defaultLiferayHome = StringUtil.replace((String)defaultLiferayHome, (String)"//", (String)"/")).endsWith("/..") && (pos = defaultLiferayHome.lastIndexOf(47, defaultLiferayHome.length() - 4)) != -1) {
            defaultLiferayHome = defaultLiferayHome.substring(0, pos);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Default Liferay home " + defaultLiferayHome));
        }
        return defaultLiferayHome;
    }

    private String _getLibDir(Class<?> clazz) {
        String path = ClassUtil.getParentPath((ClassLoader)clazz.getClassLoader(), (String)clazz.getName());
        int pos = path.lastIndexOf(".jar!");
        if (pos == -1) {
            pos = path.lastIndexOf(".jar/");
        }
        pos = path.lastIndexOf(47, pos);
        path = path.substring(0, pos + 1);
        return path;
    }

    private Properties _getProperties() {
        return this._getConfiguration().getProperties();
    }

    private Properties _getProperties(String prefix, boolean removePrefix) {
        return this._getConfiguration().getProperties(prefix, removePrefix);
    }

    private void _removeProperties(Properties properties) {
        this._getConfiguration().removeProperties(properties);
    }

    private void _set(String key, String value) {
        this._getConfiguration().set(key, value);
    }
}

