/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalSessionContext;
import com.liferay.portal.kernel.util.Time;
import java.util.Collection;
import javax.servlet.http.HttpSession;

public class MaintenanceUtil {
    private static Log _log = LogFactoryUtil.getLog(MaintenanceUtil.class);
    private static MaintenanceUtil _instance = new MaintenanceUtil();
    private String _className;
    private boolean _maintaining = false;
    private String _sessionId;
    private StringBuffer _status = new StringBuffer();

    public static void appendStatus(String status) {
        _instance._appendStatus(status);
    }

    public static void cancel() {
        _instance._cancel();
    }

    public static String getClassName() {
        return _instance._getClassName();
    }

    public static String getSessionId() {
        return _instance._getSessionId();
    }

    public static String getStatus() {
        return _instance._getStatus();
    }

    public static boolean isMaintaining() {
        return _instance._isMaintaining();
    }

    public static void maintain(String sessionId, String className) {
        _instance._maintain(sessionId, className);
    }

    private MaintenanceUtil() {
    }

    private void _appendStatus(String status) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)status);
        }
        this._status.append(Time.getRFC822() + " " + status + "<br />");
    }

    private void _cancel() {
        HttpSession session = PortalSessionContext.get((String)this._sessionId);
        if (session != null) {
            session.invalidate();
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Session " + this._sessionId + " is null"));
        }
        this._maintaining = false;
    }

    private String _getClassName() {
        return this._className;
    }

    private String _getSessionId() {
        return this._sessionId;
    }

    private String _getStatus() {
        return this._status.toString();
    }

    private boolean _isMaintaining() {
        return this._maintaining;
    }

    private void _maintain(String sessionId, String className) {
        this._sessionId = sessionId;
        this._className = className;
        this._maintaining = true;
        this._status = new StringBuffer();
        this._appendStatus("Executing " + this._className);
        Collection sessions = PortalSessionContext.values();
        for (HttpSession session : sessions) {
            if (sessionId.equals(session.getId())) continue;
            try {
                session.invalidate();
            }
            catch (IllegalStateException ise) {}
        }
    }
}

