/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.TextExtractor;

@DoPrivileged
public class HtmlImpl
implements Html {
    public static final int ESCAPE_MODE_ATTRIBUTE = 1;
    public static final int ESCAPE_MODE_CSS = 2;
    public static final int ESCAPE_MODE_JS = 3;
    public static final int ESCAPE_MODE_TEXT = 4;
    public static final int ESCAPE_MODE_URL = 5;
    private static final String[] _MS_WORD_HTML = new String[]{"&reg;", "'", "\"", "\""};
    private static final String[] _MS_WORD_UNICODE = new String[]{"\u00ae", "\u2019", "\u201c", "\u201d"};
    private static final char[] _TAG_SCRIPT = new char[]{'s', 'c', 'r', 'i', 'p', 't'};
    private static final char[] _TAG_STYLE = new char[]{'s', 't', 'y', 'l', 'e'};
    private static final char[] _XPATH_TOKENS = new char[]{'(', ')', '[', ']', '.', '@', ',', ':', '/', '|', '+', '-', '=', '!', '<', '>', '*', '$', '\"', '\"', ' ', '\t', '\n', '\r', '\u0085', '\u2028'};
    private Pattern _pattern = Pattern.compile("([\\s<&]|$)");

    public String escape(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        StringBundler sb = null;
        int lastReplacementIndex = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            String replacement = null;
            switch (c) {
                case '<': {
                    replacement = "&lt;";
                    break;
                }
                case '>': {
                    replacement = "&gt;";
                    break;
                }
                case '&': {
                    replacement = "&amp;";
                    break;
                }
                case '\"': {
                    replacement = "&#034;";
                    break;
                }
                case '\'': {
                    replacement = "&#039;";
                    break;
                }
                case '\u00bb': {
                    replacement = "&#187;";
                    break;
                }
                case '\u2013': {
                    replacement = "&#x2013;";
                    break;
                }
                case '\u2014': {
                    replacement = "&#x2014;";
                }
            }
            if (replacement == null) continue;
            if (sb == null) {
                sb = new StringBundler();
            }
            if (i > lastReplacementIndex) {
                sb.append(text.substring(lastReplacementIndex, i));
            }
            sb.append(replacement);
            lastReplacementIndex = i + 1;
        }
        if (sb == null) {
            return text;
        }
        if (lastReplacementIndex < text.length()) {
            sb.append(text.substring(lastReplacementIndex));
        }
        return sb.toString();
    }

    public String escape(String text, int mode) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        String prefix = "";
        String postfix = "";
        if (mode == 1) {
            prefix = "&#x";
            postfix = ";";
        } else if (mode == 2) {
            prefix = "\\";
        } else if (mode == 3) {
            prefix = "\\x";
        } else {
            if (mode == 5) {
                return HttpUtil.encodeURL((String)text, (boolean)true);
            }
            return this.escape(text);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c > '\u00ff' || Character.isLetterOrDigit(c) || c == '-' || c == '_') {
                sb.append(c);
                continue;
            }
            sb.append(prefix);
            String hexString = StringUtil.toHexString((int)c);
            if (hexString.length() == 1) {
                sb.append(StringPool.ASCII_TABLE[48]);
            }
            sb.append(hexString);
            sb.append(postfix);
        }
        if (sb.length() == text.length()) {
            return text;
        }
        return sb.toString();
    }

    public String escapeAttribute(String attribute) {
        return this.escape(attribute, 1);
    }

    public String escapeCSS(String css) {
        return this.escape(css, 2);
    }

    public String escapeHREF(String href) {
        String protocol;
        if (href == null) {
            return null;
        }
        if (href.length() == 0) {
            return "";
        }
        if (href.indexOf(":") == 10 && (protocol = StringUtil.toLowerCase((String)href.substring(0, 10))).equals("javascript")) {
            href = StringUtil.replaceFirst((String)href, (String)":", (String)"%3a");
        }
        return this.escapeAttribute(href);
    }

    public String escapeJS(String js) {
        return this.escape(js, 3);
    }

    public String escapeURL(String url) {
        return this.escape(url, 5);
    }

    public String escapeXPath(String xPath) {
        if (Validator.isNull((String)xPath)) {
            return xPath;
        }
        StringBuilder sb = new StringBuilder(xPath.length());
        for (int i = 0; i < xPath.length(); ++i) {
            char c = xPath.charAt(i);
            boolean hasToken = false;
            for (int j = 0; j < _XPATH_TOKENS.length; ++j) {
                if (c != _XPATH_TOKENS[j]) continue;
                hasToken = true;
                break;
            }
            if (hasToken) {
                sb.append("_");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String escapeXPathAttribute(String xPathAttribute) {
        boolean hasApostrophe = xPathAttribute.contains("'");
        boolean hasQuote = xPathAttribute.contains("\"");
        if (hasQuote && hasApostrophe) {
            Object[] parts = xPathAttribute.split("'");
            return "concat('".concat(StringUtil.merge((Object[])parts, (String)"', \"'\", '")).concat("')");
        }
        if (hasQuote) {
            return "'".concat(xPathAttribute).concat("'");
        }
        return "\"".concat(xPathAttribute).concat("\"");
    }

    public String extractText(String html) {
        if (html == null) {
            return null;
        }
        Source source = new Source((CharSequence)html);
        TextExtractor textExtractor = source.getTextExtractor();
        return textExtractor.toString();
    }

    public String fromInputSafe(String text) {
        return StringUtil.replace((String)text, (String)"&amp;", (String)"&");
    }

    public String getAUICompatibleId(String text) {
        if (Validator.isNull((String)text)) {
            return text;
        }
        StringBundler sb = null;
        int lastReplacementIndex = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c <= '\u007f' && (Validator.isChar((char)c) || Validator.isDigit((char)c)) || c > '\u007f' && c != '\u2007' && c != '\u202f' && c != '\u00a0') continue;
            if (sb == null) {
                sb = new StringBundler();
            }
            if (i > lastReplacementIndex) {
                sb.append(text.substring(lastReplacementIndex, i));
            }
            sb.append('_');
            if (c != '_') {
                sb.append(StringUtil.toHexString((int)c));
            }
            sb.append('_');
            lastReplacementIndex = i + 1;
        }
        if (sb == null) {
            return text;
        }
        if (lastReplacementIndex < text.length()) {
            sb.append(text.substring(lastReplacementIndex));
        }
        return sb.toString();
    }

    public String render(String html) {
        if (html == null) {
            return null;
        }
        Source source = new Source((CharSequence)html);
        Renderer renderer = source.getRenderer();
        return renderer.toString();
    }

    @Deprecated
    public String replaceMsWordCharacters(String text) {
        return StringUtil.replace((String)text, (String[])_MS_WORD_UNICODE, (String[])_MS_WORD_HTML);
    }

    public String replaceNewLine(String html) {
        if (html == null) {
            return null;
        }
        html = StringUtil.replace((String)html, (String)"\r\n", (String)"<br />");
        return StringUtil.replace((String)html, (String)"\n", (String)"<br />");
    }

    public String stripBetween(String text, String tag) {
        return StringUtil.stripBetween((String)text, (String)("<" + tag), (String)("</" + tag + ">"));
    }

    public String stripComments(String text) {
        return StringUtil.stripBetween((String)text, (String)"<!--", (String)"-->");
    }

    public String stripHtml(String text) {
        if (text == null) {
            return null;
        }
        text = this.stripComments(text);
        StringBuilder sb = new StringBuilder(text.length());
        int x = 0;
        int y = text.indexOf("<");
        while (y != -1) {
            sb.append(text.substring(x, y));
            sb.append(" ");
            if (this.isTag(_TAG_SCRIPT, text, y + 1)) {
                y = this.stripTag(_TAG_SCRIPT, text, y);
            } else if (this.isTag(_TAG_STYLE, text, y + 1)) {
                y = this.stripTag(_TAG_STYLE, text, y);
            }
            x = text.indexOf(">", y);
            if (x == -1 || ++x < y) break;
            y = text.indexOf("<", x);
        }
        if (y == -1) {
            sb.append(text.substring(x));
        }
        return sb.toString();
    }

    public String toInputSafe(String text) {
        return StringUtil.replace((String)text, (String[])new String[]{"&", "\""}, (String[])new String[]{"&amp;", "&quot;"});
    }

    public String unescape(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        text = StringUtil.replace((String)text, (String)"&lt;", (String)"<");
        text = StringUtil.replace((String)text, (String)"&gt;", (String)">");
        text = StringUtil.replace((String)text, (String)"&amp;", (String)"&");
        text = StringUtil.replace((String)text, (String)"&#034;", (String)"\"");
        text = StringUtil.replace((String)text, (String)"&#039;", (String)"'");
        text = StringUtil.replace((String)text, (String)"&#040;", (String)"(");
        text = StringUtil.replace((String)text, (String)"&#041;", (String)")");
        text = StringUtil.replace((String)text, (String)"&#044;", (String)",");
        text = StringUtil.replace((String)text, (String)"&#035;", (String)"#");
        text = StringUtil.replace((String)text, (String)"&#037;", (String)"%");
        text = StringUtil.replace((String)text, (String)"&#059;", (String)";");
        text = StringUtil.replace((String)text, (String)"&#061;", (String)"=");
        text = StringUtil.replace((String)text, (String)"&#043;", (String)"+");
        text = StringUtil.replace((String)text, (String)"&#045;", (String)"-");
        return text;
    }

    public String unescapeCDATA(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        text = StringUtil.replace((String)text, (String)"&lt;![CDATA[", (String)"<![CDATA[");
        text = StringUtil.replace((String)text, (String)"]]&gt;", (String)"]]>");
        return text;
    }

    public String wordBreak(String text, int columns) {
        StringBundler sb = new StringBundler();
        int length = 0;
        int lastWrite = 0;
        int pos = 0;
        Matcher matcher = this._pattern.matcher(text);
        while (matcher.find()) {
            int x;
            if (matcher.start() < pos) continue;
            while (length + matcher.start() - pos >= columns) {
                sb.append(text.substring(lastWrite, pos += columns - length));
                sb.append("<wbr/>&shy;");
                length = 0;
                lastWrite = pos;
            }
            length += matcher.start() - pos;
            String group = matcher.group();
            if (group.equals("&")) {
                x = text.indexOf(";", matcher.start());
                if (x == -1) continue;
                ++length;
                pos = x + 1;
                continue;
            }
            if (group.equals("<")) {
                x = text.indexOf(">", matcher.start());
                if (x == -1) continue;
                pos = x + 1;
                continue;
            }
            if (!group.equals(" ") && !group.equals("\n")) continue;
            length = 0;
            pos = matcher.start() + 1;
        }
        sb.append(text.substring(lastWrite));
        return sb.toString();
    }

    protected boolean isTag(char[] tag, String text, int pos) {
        if (pos + tag.length + 1 <= text.length()) {
            char item;
            for (int i = 0; i < tag.length; ++i) {
                if (Character.toLowerCase(item = text.charAt(pos++)) == tag[i]) continue;
                return false;
            }
            item = text.charAt(pos);
            return !Character.isLetter(item);
        }
        return false;
    }

    protected int stripTag(char[] tag, String text, int pos) {
        int x = pos + _TAG_SCRIPT.length;
        if ((x = text.indexOf(">", x)) < 0) {
            return pos;
        }
        if (text.charAt(x - 1) == '/') {
            return pos;
        }
        while ((x = text.indexOf("</", x)) >= 0) {
            if (this.isTag(tag, text, x + 2)) {
                pos = x;
                break;
            }
            x += 2;
        }
        return pos;
    }
}

