/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload;

import com.liferay.portal.kernel.memory.DeleteFileFinalizeAction;
import com.liferay.portal.kernel.memory.FinalizeAction;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.upload.FileItem;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsUtil;
import java.io.File;
import org.apache.commons.fileupload.disk.DiskFileItem;

public class LiferayFileItem
extends DiskFileItem
implements FileItem {
    public static final int THRESHOLD_SIZE = GetterUtil.getInteger((String)PropsUtil.get(LiferayFileItem.class.getName() + ".threshold.size"));
    private static int _counter;
    private String _encodedString;
    private String _fileName;
    private File _repository;
    private int _sizeThreshold;

    public LiferayFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold, File repository) {
        super(fieldName, contentType, isFormField, fileName, sizeThreshold, repository);
        this._fileName = fileName;
        this._sizeThreshold = sizeThreshold;
        this._repository = repository;
    }

    public String getEncodedString() {
        return this._encodedString;
    }

    public String getFileName() {
        if (this._fileName == null) {
            return null;
        }
        int pos = this._fileName.lastIndexOf("/");
        if (pos == -1) {
            pos = this._fileName.lastIndexOf("\\");
        }
        if (pos == -1) {
            return this._fileName;
        }
        return this._fileName.substring(pos + 1);
    }

    public String getFileNameExtension() {
        return FileUtil.getExtension((String)this._fileName);
    }

    public String getFullFileName() {
        return this._fileName;
    }

    public int getSizeThreshold() {
        return this._sizeThreshold;
    }

    public String getString() {
        if (this.getSize() > (long)THRESHOLD_SIZE) {
            return "";
        }
        if (this._encodedString == null) {
            return super.getString();
        }
        return this._encodedString;
    }

    public void setString(String encode) {
        try {
            this._encodedString = this.getString(encode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected File getTempFile() {
        String tempFileName = "upload_" + LiferayFileItem._getUniqueId();
        String extension = this.getFileNameExtension();
        if (extension != null) {
            tempFileName = tempFileName + "." + extension;
        }
        File tempFile = new File(this._repository, tempFileName);
        FinalizeManager.register((Object)tempFile, (FinalizeAction)new DeleteFileFinalizeAction(tempFile.getAbsolutePath()), (FinalizeManager.ReferenceFactory)FinalizeManager.PHANTOM_REFERENCE_FACTORY);
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _getUniqueId() {
        Class<LiferayFileItem> clazz = LiferayFileItem.class;
        synchronized (LiferayFileItem.class) {
            int current = _counter++;
            // ** MonitorExit[var1] (shouldn't be in output)
            String id = String.valueOf(current);
            if (current < 100000000) {
                id = ("00000000" + id).substring(id.length());
            }
            return id;
        }
    }
}

