/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.upgrade.v7_0_0.util.PortletPreferencesRow;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.blogs.BlogsPortletInstanceSettings;
import com.liferay.portlet.blogs.BlogsSettings;
import com.liferay.portlet.bookmarks.BookmarksSettings;
import com.liferay.portlet.documentlibrary.DLPortletInstanceSettings;
import com.liferay.portlet.documentlibrary.DLSettings;
import com.liferay.portlet.messageboards.MBSettings;
import com.liferay.portlet.shopping.ShoppingSettings;
import com.liferay.portlet.wiki.WikiPortletInstanceSettings;
import com.liferay.portlet.wiki.WikiSettings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import javax.portlet.PortletPreferences;

public class UpgradePortletSettings
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradePortletSettings.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPortletPreferences(PortletPreferencesRow portletPreferencesRow) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("insert into PortletPreferences (mvccVersion, portletPreferencesId, ownerId, ownerType, plid, portletId, preferences) values (?, ?, ?, ?, ?, ?, ?)");
            ps.setLong(1, portletPreferencesRow.getMvccVersion());
            ps.setLong(2, portletPreferencesRow.getPortletPreferencesId());
            ps.setLong(3, portletPreferencesRow.getOwnerId());
            ps.setInt(4, portletPreferencesRow.getOwnerType());
            ps.setLong(5, portletPreferencesRow.getPlid());
            ps.setString(6, portletPreferencesRow.getPortletId());
            ps.setString(7, portletPreferencesRow.getPreferences());
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyPortletSettingsAsServiceSettings(String portletId, int ownerType, String serviceName) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Copy portlet settings as service settings");
        }
        ResultSet rs = null;
        try {
            rs = this.getPortletPreferencesResultSet(portletId, ownerType);
            while (rs.next()) {
                PortletPreferencesRow portletPreferencesRow = this.getPortletPreferencesRow(rs);
                portletPreferencesRow.setPortletPreferencesId(this.increment());
                portletPreferencesRow.setOwnerType(2);
                portletPreferencesRow.setPortletId(serviceName);
                if (ownerType == 3) {
                    long plid = portletPreferencesRow.getPlid();
                    long groupId = this.getGroupId(plid);
                    portletPreferencesRow.setOwnerId(groupId);
                    portletPreferencesRow.setPlid(0L);
                    if (_log.isInfoEnabled()) {
                        StringBundler sb = new StringBundler(8);
                        sb.append("Copying portlet ");
                        sb.append(portletId);
                        sb.append(" settings from layout ");
                        sb.append(plid);
                        sb.append(" to service ");
                        sb.append(serviceName);
                        sb.append(" in group ");
                        sb.append(groupId);
                        _log.info((Object)sb.toString());
                    }
                }
                this.addPortletPreferences(portletPreferencesRow);
            }
        }
        catch (Throwable throwable) {
            DataAccess.deepCleanUp(rs);
            throw throwable;
        }
        DataAccess.deepCleanUp((ResultSet)rs);
    }

    protected void doUpgrade() throws Exception {
        this.upgradeMainPortlet("33", "com.liferay.portlet.blogs", 2, BlogsPortletInstanceSettings.ALL_KEYS, BlogsSettings.ALL_KEYS);
        this.upgradeMainPortlet("28", "com.liferay.portlet.bookmarks", 3, StringPool.EMPTY_ARRAY, BookmarksSettings.ALL_KEYS);
        this.upgradeMainPortlet("20", "com.liferay.portlet.documentlibrary", 2, DLPortletInstanceSettings.ALL_KEYS, DLSettings.ALL_KEYS);
        this.upgradeMainPortlet("19", "com.liferay.portlet.messageboards", 2, StringPool.EMPTY_ARRAY, MBSettings.ALL_KEYS);
        this.upgradeMainPortlet("34", "com.liferay.portlet.shopping", 2, StringPool.EMPTY_ARRAY, ShoppingSettings.ALL_KEYS);
        this.upgradeMainPortlet("36", "com.liferay.portlet.wiki", 3, WikiPortletInstanceSettings.ALL_KEYS, WikiSettings.ALL_KEYS);
        this.upgradeDisplayPortlet("110", 3, DLSettings.ALL_KEYS);
        this.upgradeDisplayPortlet("31", 3, DLSettings.ALL_KEYS);
        this.upgradeDisplayPortlet("54", 3, WikiSettings.ALL_KEYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getGroupId(long plid) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        long groupId = 0L;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select groupId from Layout where plid = ?");
            ps.setLong(1, plid);
            rs = ps.executeQuery();
            if (rs.next()) {
                groupId = rs.getLong("groupId");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return groupId;
    }

    protected ResultSet getPortletPreferencesResultSet(String portletId, int ownerType) throws Exception {
        Connection con = DataAccess.getUpgradeOptimizedConnection();
        PreparedStatement ps = con.prepareStatement("select portletPreferencesId, ownerId, ownerType, plid, portletId, preferences from PortletPreferences where ownerType = ? and portletId = ?");
        ps.setInt(1, ownerType);
        ps.setString(2, portletId);
        return ps.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetPortletPreferencesValues(String portletId, int ownerType, String[] keys) throws Exception {
        ResultSet rs = null;
        try {
            rs = this.getPortletPreferencesResultSet(portletId, ownerType);
            while (rs.next()) {
                PortletPreferencesRow portletPreferencesRow = this.getPortletPreferencesRow(rs);
                PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)portletPreferencesRow.getPreferences());
                Enumeration names = jxPortletPreferences.getNames();
                block3: while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    for (String key : keys) {
                        if (!name.startsWith(key)) continue;
                        jxPortletPreferences.reset(key);
                        continue block3;
                    }
                }
                portletPreferencesRow.setPreferences(PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences));
                this.updatePortletPreferences(portletPreferencesRow);
            }
        }
        catch (Throwable throwable) {
            DataAccess.deepCleanUp(rs);
            throw throwable;
        }
        DataAccess.deepCleanUp((ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePortletPreferences(PortletPreferencesRow portletPreferencesRow) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update PortletPreferences set mvccVersion = ?, ownerId = ?, ownerType = ?, plid = ?, portletId = ?, preferences = ? where portletPreferencesId = ?");
            ps.setLong(1, portletPreferencesRow.getMvccVersion());
            ps.setLong(2, portletPreferencesRow.getOwnerId());
            ps.setInt(3, portletPreferencesRow.getOwnerType());
            ps.setLong(4, portletPreferencesRow.getPlid());
            ps.setString(5, portletPreferencesRow.getPortletId());
            ps.setString(6, portletPreferencesRow.getPreferences());
            ps.setLong(7, portletPreferencesRow.getPortletPreferencesId());
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void upgradeDisplayPortlet(String portletId, int ownerType, String[] serviceKeys) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Upgrading display portlet " + portletId + " settings"));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Delete service keys from portlet settings");
        }
        this.resetPortletPreferencesValues(portletId, ownerType, serviceKeys);
        this.resetPortletPreferencesValues(portletId, 5, serviceKeys);
    }

    protected void upgradeMainPortlet(String portletId, String serviceName, int ownerType, String[] portletInstanceKeys, String[] serviceKeys) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Upgrading main portlet " + portletId + " settings"));
        }
        this.copyPortletSettingsAsServiceSettings(portletId, ownerType, serviceName);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Delete portlet instance keys from service settings");
        }
        this.resetPortletPreferencesValues(serviceName, 2, portletInstanceKeys);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Delete service keys from portlet settings");
        }
        this.resetPortletPreferencesValues(portletId, ownerType, serviceKeys);
        this.resetPortletPreferencesValues(portletId, 5, serviceKeys);
    }

    private PortletPreferencesRow getPortletPreferencesRow(ResultSet rs) throws Exception {
        return new PortletPreferencesRow(rs.getLong("portletPreferencesId"), rs.getLong("ownerId"), rs.getInt("ownerType"), rs.getLong("plid"), rs.getString("portletId"), rs.getString("preferences"));
    }
}

