/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.upgrade.v7_0_0.util.JournalArticleTable;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.util.ContentUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UpgradeJournal
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeJournal.class);
    private Map<String, Map<String, Long>> _bitwiseValues = new HashMap<String, Map<String, Long>>();
    private Map<String, Long> _roleIds = new HashMap<String, Long>();

    protected String addBasicWebContentStructureAndTemplate(long companyId) throws Exception {
        long groupId = this.getCompanyGroupId(companyId);
        String defaultLanguageId = UpgradeProcessUtil.getDefaultLanguageId((long)companyId);
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        List<Element> structureElements = this.getDDMStructures(defaultLocale);
        Element structureElement = structureElements.get(0);
        String name = structureElement.elementText("name");
        String description = structureElement.elementText("description");
        String localizedName = this.localize(groupId, name, defaultLanguageId);
        String localizedDescription = this.localize(groupId, description, defaultLanguageId);
        Element structureElementRootElement = structureElement.element("root");
        String xsd = structureElementRootElement.asXML();
        if (this.hasDDMStructure(groupId, name) > 0) {
            return name;
        }
        String ddmStructureUUID = PortalUUIDUtil.generate();
        long ddmStructureId = this.addDDMStructure(ddmStructureUUID, this.increment(), groupId, companyId, name, localizedName, localizedDescription, xsd);
        String ddmTemplateUUID = PortalUUIDUtil.generate();
        Element templateElement = structureElement.element("template");
        String fileName = templateElement.elementText("file-name");
        boolean cacheable = GetterUtil.getBoolean((String)templateElement.elementText("cacheable"));
        this.addDDMTemplate(ddmTemplateUUID, this.increment(), groupId, companyId, ddmStructureId, name, localizedName, localizedDescription, this.getContent(fileName), cacheable);
        long stagingGroupId = this.getStagingGroupId(groupId);
        if (stagingGroupId > 0L) {
            ddmStructureId = this.addDDMStructure(ddmStructureUUID, this.increment(), stagingGroupId, companyId, name, localizedName, localizedDescription, xsd);
            this.addDDMTemplate(ddmTemplateUUID, this.increment(), stagingGroupId, companyId, ddmStructureId, name, localizedName, localizedDescription, this.getContent(fileName), cacheable);
        }
        return name;
    }

    protected long addDDMStructure(String uuid, long ddmStructureId, long groupId, long companyId, String ddmStructureKey, String localizedName, String localizedDescription, String xsd) throws Exception {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(6);
            sb.append("insert into DDMStructure (uuid_, structureId, ");
            sb.append("groupId, companyId, userId, userName, createDate, ");
            sb.append("modifiedDate, parentStructureId, classNameId, ");
            sb.append("structureKey, name, description, definition, ");
            sb.append("storageType, type_) values (?, ?, ?, ?, ?, ?, ?, ?, ");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setString(1, uuid);
            ps.setLong(2, ddmStructureId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, this.getDefaultUserId(companyId));
            ps.setString(6, "");
            ps.setTimestamp(7, now);
            ps.setTimestamp(8, now);
            ps.setLong(9, 0L);
            ps.setLong(10, PortalUtil.getClassNameId(JournalArticle.class));
            ps.setString(11, ddmStructureKey);
            ps.setString(12, localizedName);
            ps.setString(13, localizedDescription);
            ps.setString(14, xsd);
            ps.setString(15, "xml");
            ps.setInt(16, 0);
            ps.executeUpdate();
            Map<String, Long> bitwiseValues = this.getBitwiseValues(DDMStructure.class.getName());
            ArrayList<String> actionIds = new ArrayList<String>();
            actionIds.add("VIEW");
            long bitwiseValue = this.getBitwiseValue(bitwiseValues, actionIds);
            this.addResourcePermission(companyId, DDMStructure.class.getName(), ddmStructureId, this.getRoleId(companyId, "Guest"), bitwiseValue);
            this.addResourcePermission(companyId, DDMStructure.class.getName(), ddmStructureId, this.getRoleId(companyId, "Site Member"), bitwiseValue);
        }
        catch (Exception e) {
            try {
                _log.error((Object)"Unable to create the basic web content structure");
                throw e;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps);
                throw throwable;
            }
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
        return ddmStructureId;
    }

    protected long addDDMTemplate(String uuid, long ddmTemplateId, long groupId, long companyId, long ddmStructureId, String templateKey, String localizedName, String localizedDescription, String script, boolean cacheable) throws Exception {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(6);
            sb.append("insert into DDMTemplate (uuid_, templateId, groupId, ");
            sb.append("companyId, userId, userName, createDate, modifiedDate,");
            sb.append("classNameId, classPK , templateKey, name, description,");
            sb.append("type_, mode_, language, script, cacheable, smallImage,");
            sb.append("smallImageId, smallImageURL) values (?, ?, ?, ?, ?, ?,");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setString(1, uuid);
            ps.setLong(2, ddmTemplateId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, this.getDefaultUserId(companyId));
            ps.setString(6, "");
            ps.setTimestamp(7, now);
            ps.setTimestamp(8, now);
            ps.setLong(9, PortalUtil.getClassNameId(DDMStructure.class));
            ps.setLong(10, ddmStructureId);
            ps.setString(11, templateKey);
            ps.setString(12, localizedName);
            ps.setString(13, localizedDescription);
            ps.setString(14, "display");
            ps.setString(15, "create");
            ps.setString(16, "ftl");
            ps.setString(17, script);
            ps.setBoolean(18, cacheable);
            ps.setBoolean(19, false);
            ps.setLong(20, 0L);
            ps.setString(21, "");
            ps.executeUpdate();
            Map<String, Long> bitwiseValues = this.getBitwiseValues(DDMTemplate.class.getName());
            ArrayList<String> actionIds = new ArrayList<String>();
            actionIds.add("VIEW");
            long bitwiseValue = this.getBitwiseValue(bitwiseValues, actionIds);
            this.addResourcePermission(companyId, DDMTemplate.class.getName(), ddmTemplateId, this.getRoleId(companyId, "Guest"), bitwiseValue);
            this.addResourcePermission(companyId, DDMTemplate.class.getName(), ddmTemplateId, this.getRoleId(companyId, "Site Member"), bitwiseValue);
        }
        catch (Exception e) {
            try {
                _log.error((Object)"Unable to create the basic web content template");
                throw e;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps);
                throw throwable;
            }
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
        return ddmTemplateId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResourcePermission(long companyId, String className, long primKey, long roleId, long actionIds) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            long resourcePermissionId = this.increment(ResourcePermission.class.getName());
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(3);
            sb.append("insert into ResourcePermission (resourcePermissionId, ");
            sb.append("companyId, name, scope, primKey, roleId, ownerId, ");
            sb.append("actionIds) values (?, ?, ?, ?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setLong(1, resourcePermissionId);
            ps.setLong(2, companyId);
            ps.setString(3, className);
            ps.setInt(4, 4);
            ps.setLong(5, primKey);
            ps.setLong(6, roleId);
            ps.setLong(7, 0L);
            ps.setLong(8, actionIds);
            ps.executeUpdate();
        }
        catch (Exception e) {
            block4: {
                try {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)("Unable to add resource permission " + className), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DataAccess.cleanUp(con, ps);
                    throw throwable;
                }
            }
            DataAccess.cleanUp((Connection)con, ps);
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected String convertStaticContentToDynamic(String content) throws Exception {
        Document document = SAXReaderUtil.read((String)content);
        Document newDocument = SAXReaderUtil.createDocument();
        Element rootElement = document.getRootElement();
        String availableLocales = rootElement.attributeValue("available-locales");
        String defaultLocale = rootElement.attributeValue("default-locale");
        Element newRootElement = SAXReaderUtil.createElement((String)"root");
        newRootElement.addAttribute("available-locales", availableLocales);
        newRootElement.addAttribute("default-locale", defaultLocale);
        newDocument.add(newRootElement);
        Element dynamicElementElement = SAXReaderUtil.createElement((String)"dynamic-element");
        dynamicElementElement.addAttribute("name", "content");
        dynamicElementElement.addAttribute("type", "text_area");
        dynamicElementElement.addAttribute("index-type", "keyword");
        dynamicElementElement.addAttribute("index", String.valueOf(0));
        newRootElement.add(dynamicElementElement);
        List staticContentElements = rootElement.elements("static-content");
        for (Element staticContentElement : staticContentElements) {
            String languageId = staticContentElement.attributeValue("language-id");
            String text = staticContentElement.getText();
            Element dynamicContentElement = SAXReaderUtil.createElement((String)"dynamic-content");
            dynamicContentElement.addAttribute("language-id", languageId);
            dynamicContentElement.addCDATA(text);
            dynamicElementElement.add(dynamicContentElement);
        }
        return DDMXMLUtil.formatXML((Document)newDocument);
    }

    protected void doUpgrade() throws Exception {
        this.updateBasicWebContentStructure();
        try {
            this.runSQL("alter_column_type JournalArticle description TEXT null");
        }
        catch (SQLException sqle) {
            this.upgradeTable("JournalArticle", JournalArticleTable.TABLE_COLUMNS, "create table JournalArticle (uuid_ VARCHAR(75) null,id_ LONG not null primary key,resourcePrimKey LONG,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,folderId LONG,classNameId LONG,classPK LONG,treePath STRING null,articleId VARCHAR(75) null,version DOUBLE,title STRING null,urlTitle VARCHAR(150) null,description TEXT null,content TEXT null,type_ VARCHAR(75) null,structureId VARCHAR(75) null,templateId VARCHAR(75) null,layoutUuid VARCHAR(75) null,displayDate DATE null,expirationDate DATE null,reviewDate DATE null,indexable BOOLEAN,smallImage BOOLEAN,smallImageId LONG,smallImageURL STRING null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)", JournalArticleTable.TABLE_SQL_ADD_INDEXES);
        }
    }

    protected long getBitwiseValue(Map<String, Long> bitwiseValues, List<String> actionIds) {
        long bitwiseValue = 0L;
        for (String actionId : actionIds) {
            Long actionIdBitwiseValue = bitwiseValues.get(actionId);
            if (actionIdBitwiseValue == null) continue;
            bitwiseValue |= actionIdBitwiseValue.longValue();
        }
        return bitwiseValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Long> getBitwiseValues(String name) throws Exception {
        Map<String, Long> map;
        Map<String, Long> bitwiseValues = this._bitwiseValues.get(name);
        if (bitwiseValues != null) {
            return bitwiseValues;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String currentShardName = null;
        try {
            currentShardName = ShardUtil.setTargetSource((String)PropsUtil.get((String)"shard.default.name"));
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select actionId, bitwiseValue from ResourceAction where name = ?");
            ps.setString(1, name);
            rs = ps.executeQuery();
            bitwiseValues = new HashMap<String, Long>();
            while (rs.next()) {
                String actionId = rs.getString("actionId");
                long bitwiseValue = rs.getLong("bitwiseValue");
                bitwiseValues.put(actionId, bitwiseValue);
            }
            this._bitwiseValues.put(name, bitwiseValues);
            map = bitwiseValues;
        }
        catch (Throwable throwable) {
            if (Validator.isNotNull((String)currentShardName)) {
                ShardUtil.setTargetSource((String)currentShardName);
            }
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        if (Validator.isNotNull((String)currentShardName)) {
            ShardUtil.setTargetSource((String)currentShardName);
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getCompanyGroupId(long companyId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block3: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select groupId from Group_ where classNameId = ? and classPK = ?");
                ps.setLong(1, PortalUtil.getClassNameId((String)Company.class.getName()));
                ps.setLong(2, companyId);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                l = rs.getLong("groupId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        long l = 0L;
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return l;
    }

    protected String getContent(String fileName) {
        return ContentUtil.get((String)("com/liferay/portal/events/dependencies/" + fileName));
    }

    protected List<Element> getDDMStructures(Locale locale) throws DocumentException {
        String xml = this.getContent("basic-web-content-structure.xml");
        xml = StringUtil.replace((String)xml, (String)"[$LOCALE_DEFAULT$]", (String)locale.toString());
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        return rootElement.elements("structure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getDefaultUserId(long companyId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block3: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select userId from User_ where companyId = ? and defaultUser = ?");
                ps.setLong(1, companyId);
                ps.setBoolean(2, true);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                l = rs.getLong("userId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        long l = 0L;
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getRoleId(long companyId, String name) throws Exception {
        long l;
        String roleIdsKey = companyId + "#" + name;
        Long roleId = this._roleIds.get(roleIdsKey);
        if (roleId != null) {
            return roleId;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select roleId from Role_ where companyId = ? and name = ?");
            ps.setLong(1, companyId);
            ps.setString(2, name);
            rs = ps.executeQuery();
            if (rs.next()) {
                roleId = rs.getLong("roleId");
            }
            this._roleIds.put(roleIdsKey, roleId);
            l = roleId;
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getStagingGroupId(long groupId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block3: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select groupId from Group_ where liveGroupId = ?");
                ps.setLong(1, groupId);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                l = rs.getLong("groupId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        long l = 0L;
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int hasDDMStructure(long groupId, String ddmStructureKey) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block3: {
            int n;
            con = null;
            ps = null;
            rs = null;
            try {
                int count;
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select count(*) from DDMStructure where groupId = ? and classNameId = ? and structureKey = ?");
                ps.setLong(1, groupId);
                ps.setLong(2, PortalUtil.getClassNameId((String)JournalArticle.class.getName()));
                ps.setString(3, ddmStructureKey);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                n = count = rs.getInt(1);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return n;
        }
        int n = 0;
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return n;
    }

    protected String localize(long groupId, String key, String defaultLanguageId) throws Exception {
        Locale[] locales;
        HashMap<Locale, String> localizationMap = new HashMap<Locale, String>();
        for (Locale locale : locales = LanguageUtil.getAvailableLocales((long)groupId)) {
            localizationMap.put(locale, LanguageUtil.get((Locale)locale, (String)key));
        }
        return LocalizationUtil.updateLocalization(localizationMap, (String)"", (String)key, (String)defaultLanguageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBasicWebContentStructure() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select companyId from Company");
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                this.updateJournalArticles(companyId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateJournalArticle(long id_, String ddmStructureKey, String ddmTemplateKey, String content) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update JournalArticle set structureId = ?, templateId = ?, content = ? where id_ = ?");
            ps.setString(1, ddmStructureKey);
            ps.setString(2, ddmTemplateKey);
            ps.setString(3, this.convertStaticContentToDynamic(content));
            ps.setLong(4, id_);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateJournalArticles(long companyId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select id_, content from JournalArticle where companyId = " + companyId + " and structureId is NULL or structureId " + "LIKE ''");
            String name = this.addBasicWebContentStructureAndTemplate(companyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long id_ = rs.getLong("id_");
                String content = rs.getString("content");
                this.updateJournalArticle(id_, name, name, content);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

