/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upgrade.v7_0_0.util.DLFileEntryTable;
import com.liferay.portal.upgrade.v7_0_0.util.DLFileVersionTable;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try {
            this.runSQL("alter table DLFileEntry add fileName VARCHAR(255) null");
        }
        catch (SQLException sqle) {
            this.upgradeTable("DLFileEntry", DLFileEntryTable.TABLE_COLUMNS, "create table DLFileEntry (uuid_ VARCHAR(75) null,fileEntryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,repositoryId LONG,folderId LONG,treePath STRING null,name VARCHAR(255) null,fileName VARCHAR(255) null,extension VARCHAR(75) null,mimeType VARCHAR(75) null,title VARCHAR(255) null,description STRING null,extraSettings TEXT null,fileEntryTypeId LONG,version VARCHAR(75) null,size_ LONG,readCount INTEGER,smallImageId LONG,largeImageId LONG,custom1ImageId LONG,custom2ImageId LONG,manualCheckInRequired BOOLEAN)", DLFileEntryTable.TABLE_SQL_ADD_INDEXES);
        }
        this.updateFileEntryFileNames();
        try {
            this.runSQL("alter table DLFileVersion add fileName VARCHAR(255) null");
        }
        catch (SQLException sqle) {
            this.upgradeTable("DLFileVersion", DLFileVersionTable.TABLE_COLUMNS, "create table DLFileVersion (uuid_ VARCHAR(75) null,fileVersionId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,repositoryId LONG,folderId LONG,fileEntryId LONG,treePath STRING null,fileName VARCHAR(255) null,extension VARCHAR(75) null,mimeType VARCHAR(75) null,title VARCHAR(255) null,description STRING null,changeLog VARCHAR(75) null,extraSettings TEXT null,fileEntryTypeId LONG,version VARCHAR(75) null,size_ LONG,checksum VARCHAR(75) null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)", DLFileVersionTable.TABLE_SQL_ADD_INDEXES);
        }
        this.updateFileVersionFileNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasFileEntry(long groupId, long folderId, String fileName) throws Exception {
        boolean bl;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block4: {
            boolean bl2;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select count(*) from DLFileEntry where groupId = ? and folderId = ? and fileName = ?");
                ps.setLong(1, groupId);
                ps.setLong(2, folderId);
                ps.setString(3, fileName);
                rs = ps.executeQuery();
                while (rs.next()) {
                    int count = rs.getInt(1);
                    if (count <= 0) continue;
                    bl = true;
                    break block4;
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return bl2;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileEntryFileName(long fileEntryId, String fileName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update DLFileEntry set fileName = ? where fileEntryId = ?");
            ps.setString(1, fileName);
            ps.setLong(2, fileEntryId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileEntryFileNames() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileEntryId, groupId, folderId, extension, title, version from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileEntryId = rs.getLong("fileEntryId");
                long groupId = rs.getLong("groupId");
                long folderId = rs.getLong("folderId");
                String extension = GetterUtil.getString((String)rs.getString("extension"));
                String title = GetterUtil.getString((String)rs.getString("title"));
                String version = rs.getString("version");
                String uniqueFileName = DLUtil.getSanitizedFileName((String)title, (String)extension);
                String titleExtension = "";
                String titleWithoutExtension = title;
                if (title.endsWith("." + extension)) {
                    titleExtension = extension;
                    titleWithoutExtension = FileUtil.stripExtension((String)title);
                }
                String uniqueTitle = "";
                int i = 1;
                while (this.hasFileEntry(groupId, folderId, uniqueFileName)) {
                    uniqueTitle = titleWithoutExtension + "_" + String.valueOf(i);
                    if (Validator.isNotNull((String)titleExtension)) {
                        uniqueTitle = uniqueTitle + ".".concat(titleExtension);
                    }
                    uniqueFileName = DLUtil.getSanitizedFileName((String)uniqueTitle, (String)extension);
                    ++i;
                }
                this.updateFileEntryFileName(fileEntryId, uniqueFileName);
                if (!Validator.isNotNull((String)uniqueTitle)) continue;
                this.updateFileEntryTitle(fileEntryId, uniqueTitle, version);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileEntryTitle(long fileEntryId, String title, String version) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update DLFileEntry set title = ? where fileEntryId = ?");
            ps.setString(1, title);
            ps.setLong(2, fileEntryId);
            ps.executeUpdate();
            ps = con.prepareStatement("update DLFileVersion set title = ? where fileEntryId = ? and version = ?");
            ps.setString(1, title);
            ps.setLong(2, fileEntryId);
            ps.setString(3, version);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileVersionFileName(long fileVersionId, String fileName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update DLFileVersion set fileName = ? where fileVersionId = ?");
            ps.setString(1, fileName);
            ps.setLong(2, fileVersionId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileVersionFileNames() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileVersionId, extension, title from DLFileVersion");
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileVersionId = rs.getLong("fileVersionId");
                String extension = GetterUtil.getString((String)rs.getString("extension"));
                String title = GetterUtil.getString((String)rs.getString("title"));
                String fileName = DLUtil.getSanitizedFileName((String)title, (String)extension);
                this.updateFileVersionFileName(fileVersionId, fileName);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

