/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.upgrade.v7_0_0.util.AssetEntryTable;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import com.liferay.portlet.journal.model.JournalArticle;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;

public class UpgradeAsset
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeAsset.class);

    protected void doUpgrade() throws Exception {
        try {
            this.runSQL("alter_column_type AssetEntry description TEXT null");
            this.runSQL("alter_column_type AssetEntry summary TEXT null");
        }
        catch (SQLException sqle) {
            this.upgradeTable("AssetEntry", AssetEntryTable.TABLE_COLUMNS, "create table AssetEntry (entryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,classUuid VARCHAR(75) null,classTypeId LONG,visible BOOLEAN,startDate DATE null,endDate DATE null,publishDate DATE null,expirationDate DATE null,mimeType VARCHAR(75) null,title STRING null,description TEXT null,summary TEXT null,url STRING null,layoutUuid VARCHAR(75) null,height INTEGER,width INTEGER,priority DOUBLE,viewCount INTEGER)", AssetEntryTable.TABLE_SQL_ADD_INDEXES);
        }
        this.updateAssetClassTypeId();
        this.updateAssetVocabularies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getDDMStructureId(String structureKey) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block3: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select structureId from DDMStructure where structureKey = ?");
                ps.setString(1, structureKey);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                l = rs.getLong("structureId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        long l = 0L;
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAssetClassTypeId() throws Exception {
        long classNameId = PortalUtil.getClassNameId(JournalArticle.class);
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select resourcePrimKey, structureId from JournalArticle where structureId != ''");
            rs = ps.executeQuery();
            while (rs.next()) {
                long resourcePrimKey = rs.getLong("resourcePrimKey");
                String structureId = rs.getString("structureId");
                long ddmStructureId = this.getDDMStructureId(structureId);
                this.runSQL("update AssetEntry set classTypeId = " + ddmStructureId + " where classNameId = " + classNameId + " and classPK = " + resourcePrimKey);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAssetVocabularies() throws Exception {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            connection = DataAccess.getUpgradeOptimizedConnection();
            statement = connection.prepareStatement("select vocabularyId, settings_ from AssetVocabulary");
            result = statement.executeQuery();
            while (result.next()) {
                long vocabularyId = result.getLong("vocabularyId");
                String settings = result.getString("settings_");
                this.updateAssetVocabulary(vocabularyId, this.upgradeVocabularySettings(settings));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)connection, (Statement)statement, result);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)connection, (Statement)statement, (ResultSet)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAssetVocabulary(long vocabularyId, String settings) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update AssetVocabulary set settings_ = ? where vocabularyId = ?");
            ps.setString(1, settings);
            ps.setLong(2, vocabularyId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to update vocabulary " + vocabularyId), (Throwable)e);
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
    }

    protected String upgradeVocabularySettings(String settings) {
        UnicodeProperties properties = new UnicodeProperties(true);
        properties.fastLoad(settings);
        AssetVocabularySettingsHelper vocabularySettingsHelper = new AssetVocabularySettingsHelper();
        vocabularySettingsHelper.setMultiValued(GetterUtil.getBoolean((String)properties.getProperty("multiValued"), (boolean)true));
        long[] classNameIds = StringUtil.split((String)properties.getProperty("selectedClassNameIds"), (long)0L);
        long[] classTypePKs = new long[classNameIds.length];
        Arrays.fill(classTypePKs, -1L);
        long[] requiredClassNameIds = StringUtil.split((String)properties.getProperty("requiredClassNameIds"), (long)0L);
        boolean[] requireds = new boolean[classNameIds.length];
        for (int i = 0; i < classNameIds.length; ++i) {
            requireds[i] = ArrayUtil.contains((long[])requiredClassNameIds, (long)classNameIds[i]);
        }
        vocabularySettingsHelper.setClassNameIdsAndClassTypePKs(classNameIds, classTypePKs, requireds);
        return vocabularySettingsHelper.toString();
    }
}

