/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.wiki.model.WikiPage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;

public class UpgradeSocial
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeSocial.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addActivity(long activityId, long groupId, long companyId, long userId, Timestamp createDate, long mirrorActivityId, long classNameId, long classPK, int type, String extraData, long receiverUserId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(5);
            sb.append("insert into SocialActivity (activityId, groupId, ");
            sb.append("companyId, userId, createDate, mirrorActivityId, ");
            sb.append("classNameId, classPK, type_, extraData, ");
            sb.append("receiverUserId) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            sb.append("?)");
            ps = con.prepareStatement(sb.toString());
            ps.setLong(1, activityId);
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, userId);
            ps.setLong(5, createDate.getTime());
            ps.setLong(6, mirrorActivityId);
            ps.setLong(7, classNameId);
            ps.setLong(8, classPK);
            ps.setInt(9, type);
            ps.setString(10, extraData);
            ps.setLong(11, receiverUserId);
            ps.executeUpdate();
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to add activity " + activityId), (Throwable)e);
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, ps, rs);
        }
    }

    protected void doUpgrade() throws Exception {
        this.updateDLFileVersionActivities();
        this.updateJournalActivities();
        this.updateSOSocialActivities();
        this.updateWikiPageActivities();
    }

    protected Timestamp getUniqueModifiedDate(Set<String> keys, long groupId, long userId, Timestamp modifiedDate, long classNameId, long resourcePrimKey, double type) {
        String key;
        do {
            StringBundler sb = new StringBundler(11);
            sb.append(groupId);
            sb.append("-");
            sb.append(userId);
            sb.append("-");
            sb.append((Object)modifiedDate);
            sb.append("-");
            sb.append(classNameId);
            sb.append("-");
            sb.append(resourcePrimKey);
            sb.append("-");
            sb.append(type);
            key = sb.toString();
            modifiedDate = new Timestamp(modifiedDate.getTime() + 1L);
        } while (keys.contains(key));
        keys.add(key);
        return modifiedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDLFileVersionActivities() throws Exception {
        long classNameId = PortalUtil.getClassNameId(DLFileEntry.class);
        this.runSQL("delete from SocialActivity where classNameId = " + classNameId);
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            HashSet<String> keys = new HashSet<String>();
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select groupId, companyId, userId, modifiedDate, fileEntryId, title, version from DLFileVersion where status = ?");
            ps.setInt(1, 0);
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                long fileEntryId = rs.getLong("fileEntryId");
                String title = rs.getString("title");
                double version = rs.getDouble("version");
                int type = 1;
                if (version > 1.0) {
                    type = 2;
                }
                modifiedDate = this.getUniqueModifiedDate(keys, groupId, userId, modifiedDate, classNameId, fileEntryId, type);
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
                extraDataJSONObject.put("title", title);
                this.addActivity(this.increment(), groupId, companyId, userId, modifiedDate, 0L, classNameId, fileEntryId, type, extraDataJSONObject.toString(), 0L);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateJournalActivities() throws Exception {
        String[] tableNames;
        long classNameId = PortalUtil.getClassNameId(JournalArticle.class);
        for (String tableName : tableNames = new String[]{"SocialActivity", "SocialActivityCounter"}) {
            StringBundler sb = new StringBundler(7);
            sb.append("update ");
            sb.append(tableName);
            sb.append(" set classPK = (select resourcePrimKey ");
            sb.append("from JournalArticle where id_ = ");
            sb.append(tableName);
            sb.append(".classPK) where classNameId = ");
            sb.append(classNameId);
            this.runSQL(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSOSocialActivities() throws Exception {
        if (!this.hasTable("SO_SocialActivity")) {
            return;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select activityId, activitySetId from SO_SocialActivity");
            rs = ps.executeQuery();
            while (rs.next()) {
                long activityId = rs.getLong("activityId");
                long activitySetId = rs.getLong("activitySetId");
                StringBundler sb = new StringBundler(4);
                sb.append("update SocialActivity set activitySetId = ");
                sb.append(activitySetId);
                sb.append(" where activityId = ");
                sb.append(activityId);
                this.runSQL(sb.toString());
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        this.runSQL("drop table SO_SocialActivity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWikiPageActivities() throws Exception {
        long classNameId = PortalUtil.getClassNameId(WikiPage.class);
        this.runSQL("delete from SocialActivity where classNameId = " + classNameId);
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            HashSet<String> keys = new HashSet<String>();
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select groupId, companyId, userId, modifiedDate, resourcePrimKey, version from WikiPage");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                long resourcePrimKey = rs.getLong("resourcePrimKey");
                double version = rs.getDouble("version");
                int type = 1;
                if (version > 1.0) {
                    type = 2;
                }
                modifiedDate = this.getUniqueModifiedDate(keys, groupId, userId, modifiedDate, classNameId, resourcePrimKey, type);
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
                extraDataJSONObject.put("version", version);
                this.addActivity(this.increment(), groupId, companyId, userId, modifiedDate, 0L, classNameId, resourcePrimKey, type, extraDataJSONObject.toString(), 0L);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

