/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.upgrade.v6_2_0.util.DDMTemplateTable;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class UpgradeDynamicDataMapping
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeDynamicDataMapping.class);

    protected void doUpgrade() throws Exception {
        block4: {
            try {
                this.runSQL("alter table DDMTemplate add classNameId LONG");
                this.runSQL("alter table DDMTemplate add templateKey STRING");
                this.runSQL("alter_column_name DDMTemplate structureId classPK LONG");
            }
            catch (SQLException sqle) {
                this.upgradeTable("DDMTemplate", DDMTemplateTable.TABLE_COLUMNS, "create table DDMTemplate (uuid_ VARCHAR(75) null,templateId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,templateKey VARCHAR(75) null,name STRING null,description STRING null,type_ VARCHAR(75) null,mode_ VARCHAR(75) null,language VARCHAR(75) null,script TEXT null,cacheable BOOLEAN,smallImage BOOLEAN,smallImageId LONG,smallImageURL VARCHAR(75) null)", DDMTemplateTable.TABLE_SQL_ADD_INDEXES);
            }
            long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
            try {
                this.runSQL("update DDMTemplate set classNameId = " + classNameId);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        this.updateStructures();
        this.updateTemplates();
    }

    protected void updateMetadataElement(Element metadataElement, String[] relocatedMetadadaEntryNames, String[] removedMetadataEntryNames) {
        Element parentElement = metadataElement.getParent();
        List entryElements = metadataElement.elements("entry");
        for (Element entryElement : entryElements) {
            String name = entryElement.attributeValue("name");
            if (ArrayUtil.contains((Object[])removedMetadataEntryNames, (Object)name)) {
                metadataElement.remove(entryElement);
                continue;
            }
            if (!ArrayUtil.contains((Object[])relocatedMetadadaEntryNames, (Object)name)) continue;
            parentElement.addAttribute(name, entryElement.getText());
            metadataElement.remove(entryElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStructure(long structureId, String structureKey, String xsd) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update DDMStructure set structureKey = ?, xsd = ? where structureId = ?");
            ps.setString(1, structureKey);
            ps.setString(2, xsd);
            ps.setLong(3, structureId);
            ps.executeUpdate();
        }
        catch (SQLException sqle) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)sqle, (Throwable)sqle);
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStructures() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select structureId, structureKey, xsd from DDMStructure");
            rs = ps.executeQuery();
            while (rs.next()) {
                long structureId = rs.getLong("structureId");
                String structureKey = rs.getString("structureKey");
                String xsd = rs.getString("xsd");
                structureKey = Validator.isNull((String)structureKey) ? String.valueOf(System.currentTimeMillis()) : StringUtil.toUpperCase((String)structureKey.trim());
                this.updateStructure(structureId, structureKey, this.updateXSD(xsd, structureKey));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTemplate(long templateId, String templateKey, String script) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update DDMTemplate set templateKey = ?, script = ? where templateId = ?");
            ps.setString(1, templateKey);
            ps.setString(2, script);
            ps.setLong(3, templateId);
            ps.executeUpdate();
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTemplates() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select templateId, templateKey, script from DDMTemplate where language = 'xsd'");
            rs = ps.executeQuery();
            while (rs.next()) {
                long templateId = rs.getLong("templateId");
                String templateKey = rs.getString("templateKey");
                String script = rs.getString("script");
                templateKey = Validator.isNull((String)templateKey) ? String.valueOf(System.currentTimeMillis()) : StringUtil.toUpperCase((String)templateKey.trim());
                this.updateTemplate(templateId, templateKey, this.updateXSD(script, ""));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected String updateXSD(String xsd, String structureKey) throws Exception {
        Document document = SAXReaderUtil.read((String)xsd);
        Element rootElement = document.getRootElement();
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateXSDDynamicElement(dynamicElementElement, structureKey);
        }
        return DDMXMLUtil.formatXML((Document)document);
    }

    protected void updateXSDDynamicElement(Element element, String structureKey) {
        Element metadataElement = element.element("meta-data");
        this.updateMetadataElement(metadataElement, new String[]{"multiple", "name", "readOnly", "repeatable", "required", "showLabel", "type", "width"}, new String[]{"acceptFiles", "displayChildLabelAsValue", "fieldCssClass", "folder"});
        if (StringUtil.equalsIgnoreCase((String)structureKey, (String)"TIKARAWMETADATA")) {
            element.addAttribute("indexType", "text");
        }
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateXSDDynamicElement(dynamicElementElement, structureKey);
        }
    }
}

