/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_1;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateFileEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasFileEntry(long groupId, long folderId, String title) throws Exception {
        boolean bl;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block4: {
            boolean bl2;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select count(*) from DLFileEntry where groupId = ? and folderId = ? and title = ?");
                ps.setLong(1, groupId);
                ps.setLong(2, folderId);
                ps.setString(3, title);
                rs = ps.executeQuery();
                while (rs.next()) {
                    int count = rs.getInt(1);
                    if (count <= 0) continue;
                    bl = true;
                    break block4;
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return bl2;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileEntries() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileEntryId, groupId, folderId, title, extension, version from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileEntryId = rs.getLong("fileEntryId");
                long groupId = rs.getLong("groupId");
                long folderId = rs.getLong("folderId");
                String title = rs.getString("title");
                String extension = GetterUtil.getString((String)rs.getString("extension"));
                String version = rs.getString("version");
                String periodAndExtension = ".".concat(extension);
                if (!title.endsWith(periodAndExtension)) continue;
                String uniqueTitle = title = FileUtil.stripExtension((String)title);
                int count = 0;
                while (this.hasFileEntry(groupId, folderId, uniqueTitle) || count != 0 && this.hasFileEntry(groupId, folderId, uniqueTitle + periodAndExtension)) {
                    uniqueTitle = title + String.valueOf(++count);
                }
                if (count <= 0) continue;
                uniqueTitle = uniqueTitle + periodAndExtension;
                ps = con.prepareStatement("update DLFileEntry set title = ? where fileEntryId = ?");
                ps.setString(1, uniqueTitle);
                ps.setLong(2, fileEntryId);
                ps.executeUpdate();
                ps = con.prepareStatement("update DLFileVersion set title = ? where fileEntryId = ? and version = ?");
                ps.setString(1, uniqueTitle);
                ps.setLong(2, fileEntryId);
                ps.setString(3, version);
                ps.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

