/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;

public class UpgradeSubscription
extends UpgradeProcess {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubscription(long subscriptionId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long classNameId, long classPK, String frequency) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(4);
            sb.append("insert into Subscription (subscriptionId, companyId, ");
            sb.append("userId, userName, createDate, modifiedDate, ");
            sb.append("classNameId, classPK, frequency) values (?, ?, ?, ?, ");
            sb.append("?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setLong(1, subscriptionId);
            ps.setLong(2, companyId);
            ps.setLong(3, userId);
            ps.setString(4, userName);
            ps.setTimestamp(5, createDate);
            ps.setTimestamp(6, modifiedDate);
            ps.setLong(7, classNameId);
            ps.setLong(8, classPK);
            ps.setString(9, frequency);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void doUpgrade() throws Exception {
        long[] companyIds;
        if (!PropsValues.DISCUSSION_SUBSCRIBE_BY_DEFAULT) {
            return;
        }
        for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
            this.updateMBMessages(companyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasSubscription(long companyId, long userId, long classNameId, long classPK) throws Exception {
        boolean bl;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block4: {
            boolean bl2;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select count(*) from Subscription where companyId = ? and userId = ? and classNameId = ? and classPK = ?");
                ps.setLong(1, companyId);
                ps.setLong(2, userId);
                ps.setLong(3, classNameId);
                ps.setLong(4, classPK);
                rs = ps.executeQuery();
                while (rs.next()) {
                    int count = rs.getInt(1);
                    if (count <= 0) continue;
                    bl = true;
                    break block4;
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return bl2;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMBMessages(long companyId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(8);
            sb.append("select userId, MIN(userName) as userName, ");
            sb.append("classNameId, classPK, MIN(createDate) as createDate, ");
            sb.append("MIN(modifiedDate) as modifiedDate from MBMessage ");
            sb.append("where (companyId = ");
            sb.append(companyId);
            sb.append(") and ");
            sb.append("(classNameId != 0) and (parentMessageId != 0) ");
            sb.append("group by userId, classNameId, classPK");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                long classPK;
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                long classNameId = rs.getLong("classNameId");
                if (this.hasSubscription(companyId, userId, classNameId, classPK = rs.getLong("classPK"))) continue;
                long subscriptionId = this.increment();
                String frequency = "instant";
                this.addSubscription(subscriptionId, companyId, userId, userName, createDate, modifiedDate, classNameId, classPK, frequency);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

