/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.upgrade.v6_1_0.util.JournalArticleTable;
import com.liferay.portal.upgrade.v6_1_0.util.JournalStructureTable;
import com.liferay.portal.upgrade.v6_1_0.util.JournalTemplateTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class UpgradeJournal
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try {
            this.runSQL("alter_column_type JournalArticle title STRING null");
            this.runSQL("alter_column_type JournalStructure name STRING null");
            this.runSQL("alter_column_type JournalStructure description STRING null");
            this.runSQL("alter_column_type JournalTemplate name STRING null");
            this.runSQL("alter_column_type JournalTemplate description STRING null");
        }
        catch (SQLException sqle) {
            this.upgradeTable("JournalArticle", JournalArticleTable.TABLE_COLUMNS, "create table JournalArticle (uuid_ VARCHAR(75) null,id_ LONG not null primary key,resourcePrimKey LONG,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,articleId VARCHAR(75) null,version DOUBLE,title STRING null,urlTitle VARCHAR(150) null,description STRING null,content TEXT null,type_ VARCHAR(75) null,structureId VARCHAR(75) null,templateId VARCHAR(75) null,layoutUuid VARCHAR(75) null,displayDate DATE null,expirationDate DATE null,reviewDate DATE null,indexable BOOLEAN,smallImage BOOLEAN,smallImageId LONG,smallImageURL STRING null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)", JournalArticleTable.TABLE_SQL_ADD_INDEXES);
            this.upgradeTable("JournalStructure", JournalStructureTable.TABLE_COLUMNS, "create table JournalStructure (uuid_ VARCHAR(75) null,id_ LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,structureId VARCHAR(75) null,parentStructureId VARCHAR(75) null,name STRING null,description STRING null,xsd TEXT null)", JournalStructureTable.TABLE_SQL_ADD_INDEXES);
            this.upgradeTable("JournalTemplate", JournalTemplateTable.TABLE_COLUMNS, "create table JournalTemplate (uuid_ VARCHAR(75) null,id_ LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,templateId VARCHAR(75) null,structureId VARCHAR(75) null,name STRING null,description STRING null,xsl TEXT null,langType VARCHAR(75) null,cacheable BOOLEAN,smallImage BOOLEAN,smallImageId LONG,smallImageURL STRING null)", JournalTemplateTable.TABLE_SQL_ADD_INDEXES);
        }
        this.updateStructureXsd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStructureXsd() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            this.runSQL("update JournalStructure set xsd = replace(xsd, 'image_gallery', 'document_library') where xsd like '%image_gallery%'");
        }
        catch (Exception e) {
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select id_, xsd from JournalStructure where xsd like '%image_gallery%'");
                rs = ps.executeQuery();
                while (rs.next()) {
                    long id = rs.getLong("id_");
                    String xsd = rs.getString("xsd");
                    xsd = StringUtil.replace((String)xsd, (String)"image_gallery", (String)"document_library");
                    this.updateStructureXsd(id, xsd);
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
        DataAccess.cleanUp((Connection)con, ps, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStructureXsd(long id, String xsd) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update JournalStructure set xsd = ? where id_ = ?");
            ps.setString(1, xsd);
            ps.setLong(2, id);
            ps.executeUpdate();
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
    }
}

