/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.upgrade.v6_1_0.util.GroupTable;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class UpgradeGroup
extends UpgradeProcess {
    private static final String _ORGANIZATION_NAME_DELIMETER = " LFR_ORGANIZATION ";

    protected void doUpgrade() throws Exception {
        try {
            this.runSQL("alter_column_type Group_ name VARCHAR(150) null");
        }
        catch (SQLException sqle) {
            this.upgradeTable("Group_", GroupTable.TABLE_COLUMNS, "create table Group_ (groupId LONG not null primary key,companyId LONG,creatorUserId LONG,classNameId LONG,classPK LONG,parentGroupId LONG,liveGroupId LONG,name VARCHAR(150) null,description STRING null,type_ INTEGER,typeSettings STRING null,friendlyURL VARCHAR(100) null,site BOOLEAN,active_ BOOLEAN)", GroupTable.TABLE_SQL_ADD_INDEXES);
        }
        this.updateName();
        this.updateSite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getClassNameId(String className) throws Exception {
        String currentShardName;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block6: {
            long l;
            con = null;
            ps = null;
            rs = null;
            currentShardName = null;
            try {
                currentShardName = ShardUtil.setTargetSource((String)PropsValues.SHARD_DEFAULT_NAME);
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select classNameId from ClassName_ where value = ?");
                ps.setString(1, className);
                rs = ps.executeQuery();
                if (!rs.next()) break block6;
                l = rs.getLong("classNameId");
            }
            catch (Throwable throwable) {
                if (Validator.isNotNull((String)currentShardName)) {
                    ShardUtil.setTargetSource((String)currentShardName);
                }
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            if (Validator.isNotNull((String)currentShardName)) {
                ShardUtil.setTargetSource((String)currentShardName);
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        long l = 0L;
        if (Validator.isNotNull((String)currentShardName)) {
            ShardUtil.setTargetSource((String)currentShardName);
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateName() throws Exception {
        long organizationClassNameId = this.getClassNameId(Organization.class.getName());
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(4);
            sb.append("select Group_.groupId, Group_.classPK, ");
            sb.append("Organization_.name from Group_ inner join ");
            sb.append("Organization_ on Organization_.organizationId = ");
            sb.append("Group_.classPK where classNameId = ?");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setLong(1, organizationClassNameId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long classPK = rs.getLong("classPK");
                String name = rs.getString("name");
                this.updateName(groupId, classPK, name);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateName(long groupId, long classPK, String name) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update Group_ set name = ? where groupId = ?");
            StringBundler sb = new StringBundler(3);
            sb.append(classPK);
            sb.append(_ORGANIZATION_NAME_DELIMETER);
            sb.append(name);
            ps.setString(1, sb.toString());
            ps.setLong(2, groupId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSite() throws Exception {
        long groupClassNameId = this.getClassNameId(Group.class.getName());
        this.runSQL("update Group_ set site = TRUE where classNameId = " + groupClassNameId);
        long organizationClassNameId = this.getClassNameId(Organization.class.getName());
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            String sql = "select distinct Group_.groupId from Group_ inner join Layout on Layout.groupId = Group_.groupId where classNameId = ?";
            ps = con.prepareStatement(sql);
            ps.setLong(1, organizationClassNameId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                this.runSQL("update Group_ set site = TRUE where groupId = " + groupId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

