/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.upgrade.v6_1_0.util.DLFileVersionTable;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.impl.DLFileVersionImpl;
import com.liferay.portlet.documentlibrary.util.ImageProcessorUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Set;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeDocumentLibrary.class);
    private static Set<String> _imageMimeTypes = SetUtil.fromArray((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_IMAGE_MIME_TYPES);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSync(long syncId, long companyId, Timestamp createDate, Timestamp modifiedDate, long fileId, long repositoryId, long parentFolderId, String event, String type) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("insert into DLSync (syncId, companyId, createDate, modifiedDate, fileId, repositoryId, parentFolderId, event, type_) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            ps.setLong(1, syncId);
            ps.setLong(2, companyId);
            ps.setTimestamp(3, createDate);
            ps.setTimestamp(4, createDate);
            ps.setLong(5, fileId);
            ps.setLong(6, repositoryId);
            ps.setLong(7, parentFolderId);
            ps.setString(8, event);
            ps.setString(9, type);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void doUpgrade() throws Exception {
        this.updateFileEntries();
        this.updateFileRanks();
        this.updateFileShortcuts();
        this.updateFileVersions();
        this.updateLocks();
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_AUTO_CREATE_ON_UPGRADE) {
            this.updateThumbnails();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getFileEntryId(long groupId, long folderId, String name) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block3: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select fileEntryId from DLFileEntry where groupId = ? and folderId = ? and name = ?");
                ps.setLong(1, groupId);
                ps.setLong(2, folderId);
                ps.setString(3, name);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                l = rs.getLong("fileEntryId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        long l = 0L;
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getGroupId(long folderId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        long groupId = 0L;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select groupId from DLFolder where folderId = ?");
            ps.setLong(1, folderId);
            rs = ps.executeQuery();
            if (rs.next()) {
                groupId = rs.getLong("groupId");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return groupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileEntries() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileEntryId, extension from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileEntryId = rs.getLong("fileEntryId");
                String extension = rs.getString("extension");
                String mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
                this.runSQL("update DLFileEntry set mimeType = '" + mimeType + "' where fileEntryId = " + fileEntryId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileRanks() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select groupId, fileRankId, folderId, name from DLFileRank");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long fileRankId = rs.getLong("fileRankId");
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                long fileEntryId = this.getFileEntryId(groupId, folderId, name);
                this.runSQL("update DLFileRank set fileEntryId = " + fileEntryId + " where fileRankId = " + fileRankId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        this.runSQL("alter table DLFileRank drop column folderId");
        this.runSQL("alter table DLFileRank drop column name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileShortcuts() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileShortcutId, toFolderId, toName from DLFileShortcut");
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileShortcutId = rs.getLong("fileShortcutId");
                long toFolderId = rs.getLong("toFolderId");
                String toName = rs.getString("toName");
                long groupId = this.getGroupId(toFolderId);
                long toFileEntryId = this.getFileEntryId(groupId, toFolderId, toName);
                this.runSQL("update DLFileShortcut set toFileEntryId = " + toFileEntryId + " where fileShortcutId = " + fileShortcutId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        this.runSQL("alter table DLFileShortcut drop column toFolderId");
        this.runSQL("alter table DLFileShortcut drop column toName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileVersions() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select groupId, fileVersionId, folderId, name, extension from DLFileVersion");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long fileVersionId = rs.getLong("fileVersionId");
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                String extension = rs.getString("extension");
                String mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
                long fileEntryId = this.getFileEntryId(groupId, folderId, name);
                this.runSQL("update DLFileVersion set fileEntryId = " + fileEntryId + ", mimeType = '" + mimeType + "' where fileVersionId = " + fileVersionId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        try {
            this.runSQL("alter_column_type DLFileVersion extraSettings TEXT null");
            this.runSQL("alter_column_type DLFileVersion title VARCHAR(255) null");
            this.runSQL("alter table DLFileVersion drop column name");
        }
        catch (SQLException sqle) {
            this.upgradeTable("DLFileVersion", DLFileVersionTable.TABLE_COLUMNS, "create table DLFileVersion (fileVersionId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,repositoryId LONG,folderId LONG,fileEntryId LONG,extension VARCHAR(75) null,mimeType VARCHAR(75) null,title VARCHAR(255) null,description STRING null,changeLog VARCHAR(75) null,extraSettings TEXT null,fileEntryTypeId LONG,version VARCHAR(75) null,size_ LONG,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)", DLFileVersionTable.TABLE_SQL_ADD_INDEXES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocks() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select lockId, key_ from Lock_ where className = ?");
            ps.setString(1, DLFileEntry.class.getName());
            rs = ps.executeQuery();
            while (rs.next()) {
                String name;
                long folderId;
                long groupId;
                long fileEntryId;
                long lockId = rs.getLong("lockId");
                String key = rs.getString("key_");
                String[] keyArray = StringUtil.split((String)key, (char)'#');
                if (keyArray.length != 3 || (fileEntryId = this.getFileEntryId(groupId = GetterUtil.getLong((String)keyArray[0]), folderId = GetterUtil.getLong((String)keyArray[1]), name = keyArray[2])) <= 0L) continue;
                this.runSQL("update Lock_ set key_ = '" + fileEntryId + "' where lockId = " + lockId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSyncs() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(10);
            sb.append("select DLFileEntry.fileEntryId as fileId, ");
            sb.append("DLFileEntry.groupId as groupId, DLFileEntry.companyId");
            sb.append(" as companyId, DLFileEntry.createDate as createDate, ");
            sb.append("DLFileEntry.folderId as parentFolderId, 'file' as ");
            sb.append("type from DLFileEntry union all select ");
            sb.append("DLFolder.folderId as fileId, DLFolder.groupId as ");
            sb.append("groupId, DLFolder.companyId as companyId, ");
            sb.append("DLFolder.createDate as createDate, ");
            sb.append("DLFolder.parentFolderId as parentFolderId, 'folder' ");
            sb.append("as type from DLFolder");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileId = rs.getLong("fileId");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                Timestamp createDate = rs.getTimestamp("createDate");
                long parentFolderId = rs.getLong("parentFolderId");
                String type = rs.getString("type");
                this.addSync(this.increment(), companyId, createDate, createDate, fileId, groupId, parentFolderId, "add", type);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateThumbnails() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileEntryId from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileEntryId = rs.getLong("fileEntryId");
                this.updateThumbnails(fileEntryId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateThumbnails(long fileEntryId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileVersionId, userId, extension, mimeType, version from DLFileVersion where fileEntryId = " + fileEntryId + " order by version asc");
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileVersionId = rs.getLong("fileVersionId");
                long userId = rs.getLong("userId");
                String extension = rs.getString("extension");
                String mimeType = rs.getString("mimeType");
                String version = rs.getString("version");
                if (!_imageMimeTypes.contains(mimeType)) continue;
                DLFileVersionImpl dlFileVersion = new DLFileVersionImpl();
                dlFileVersion.setFileVersionId(fileVersionId);
                dlFileVersion.setUserId(userId);
                dlFileVersion.setFileEntryId(fileEntryId);
                dlFileVersion.setExtension(extension);
                dlFileVersion.setMimeType(mimeType);
                dlFileVersion.setVersion(version);
                LiferayFileVersion fileVersion = new LiferayFileVersion(dlFileVersion);
                try {
                    ImageProcessorUtil.generateImages(null, (FileVersion)fileVersion);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to generate thumbnails for " + fileVersion.getFileVersionId()), (Throwable)e);
                }
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

