/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_3;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradePermission
extends UpgradeProcess {
    private static final String _ROLE_COMMUNITY_CONTENT_REVIEWER = "Community Content Reviewer";
    private static final String _ROLE_ORGANIZATION_CONTENT_REVIEWER = "Organization Content Reviewer";
    private static final String _ROLE_PORTAL_CONTENT_REVIEWER = "Portal Content Reviewer";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRole(long roleId, long companyId, long classNameId, long classPK, String name, int type) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("insert into Role_ (roleId, companyId, classNameId, classPK, name, type_) values (?, ?, ?, ?, ?, ?)");
            ps.setLong(1, roleId);
            ps.setLong(2, companyId);
            ps.setLong(3, classNameId);
            ps.setLong(4, classPK);
            ps.setString(5, name);
            ps.setInt(6, type);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void addSingleApproverWorkflowRoles() throws Exception {
        long[] companyIds;
        for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
            this.addSingleApproverWorkflowRoles(companyId);
        }
    }

    protected void addSingleApproverWorkflowRoles(long companyId) throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)Role.class.getName());
        long roleId = this.increment();
        this.addRole(roleId, companyId, classNameId, roleId, _ROLE_COMMUNITY_CONTENT_REVIEWER, 2);
        classNameId = PortalUtil.getClassNameId((String)Organization.class.getName());
        roleId = this.increment();
        this.addRole(roleId, companyId, classNameId, roleId, _ROLE_ORGANIZATION_CONTENT_REVIEWER, 3);
        classNameId = PortalUtil.getClassNameId((String)Company.class.getName());
        roleId = this.increment();
        this.addRole(roleId, companyId, classNameId, roleId, _ROLE_PORTAL_CONTENT_REVIEWER, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUserGroupRole(long userId, long groupId, long roleId) throws Exception {
        if (this.hasUserGroupRole(userId, groupId, roleId)) {
            return;
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("insert into UserGroupRole (userId, groupId, roleId) values (?, ?, ?)");
            ps.setLong(1, userId);
            ps.setLong(2, groupId);
            ps.setLong(3, roleId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUserRole(long userId, long roleId) throws Exception {
        if (this.hasUserRole(userId, roleId)) {
            return;
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("insert into Users_Roles (userId, roleId) values (?, ?)");
            ps.setLong(1, userId);
            ps.setLong(2, roleId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assignSingleApproverWorkflowRoles(long companyId, long roleId, long groupId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select classNameId from Group_ where groupId = ?");
            ps.setLong(1, groupId);
            rs = ps.executeQuery();
            long classNameId = 0L;
            if (rs.next()) {
                classNameId = rs.getLong("classNameId");
            }
            String className = PortalUtil.getClassName((long)classNameId);
            long communityContentReviewerRoleId = this.getRoleId(companyId, _ROLE_COMMUNITY_CONTENT_REVIEWER);
            long organizationContentReviewerRoleId = this.getRoleId(companyId, _ROLE_ORGANIZATION_CONTENT_REVIEWER);
            long portalContentReviewerRoleId = this.getRoleId(companyId, _ROLE_PORTAL_CONTENT_REVIEWER);
            StringBundler sb = new StringBundler(5);
            sb.append("(select User_.* from User_, Users_Roles where ");
            sb.append("User_.userId = Users_Roles.userId and ");
            sb.append("Users_Roles.roleId = ?) union all (select User_.* ");
            sb.append("from User_, UserGroupRole where User_.userId = ");
            sb.append("UserGroupRole.userId and UserGroupRole.roleId = ?)");
            ps = con.prepareStatement(sb.toString());
            ps.setLong(1, roleId);
            ps.setLong(2, roleId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long userId = rs.getLong("userId");
                if (className.equals(Company.class.getName())) {
                    this.addUserRole(userId, portalContentReviewerRoleId);
                    continue;
                }
                if (className.equals(Group.class.getName())) {
                    this.addUserGroupRole(userId, groupId, communityContentReviewerRoleId);
                    continue;
                }
                if (!className.equals(Organization.class.getName())) continue;
                this.addUserGroupRole(userId, groupId, organizationContentReviewerRoleId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void doUpgrade() throws Exception {
        this.addSingleApproverWorkflowRoles();
        this.updatePermissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getRoleId(long companyId, String name) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block3: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select roleId from Role_ where companyId = ? and name = ?");
                ps.setLong(1, companyId);
                ps.setString(2, name);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                l = rs.getLong("roleId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        long l = 0L;
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasUserGroupRole(long userId, long groupId, long roleId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block3: {
            boolean bl;
            con = null;
            ps = null;
            rs = null;
            try {
                int count;
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select count(*) from UserGroupRole where userId = ? and groupId = ? and roleId = ?");
                ps.setLong(1, userId);
                ps.setLong(2, groupId);
                ps.setLong(3, roleId);
                rs = ps.executeQuery();
                if (!rs.next() || (count = rs.getInt(1)) <= 0) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return bl;
        }
        boolean bl = false;
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasUserRole(long userId, long roleId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block3: {
            boolean bl;
            con = null;
            ps = null;
            rs = null;
            try {
                int count;
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select count(*) from Users_Roles where userId = ? and roleId = ?");
                ps.setLong(1, userId);
                ps.setLong(2, roleId);
                rs = ps.executeQuery();
                if (!rs.next() || (count = rs.getInt(1)) <= 0) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return bl;
        }
        boolean bl = false;
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePermissions() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(11);
            sb.append("select ResourcePermission.companyId, ");
            sb.append("ResourcePermission.roleId, ResourcePermission.primKey ");
            sb.append("from ResourcePermission, ResourceAction where ");
            sb.append("ResourceAction.name = 'com.liferay.portlet.journal' ");
            sb.append("and ResourceAction.name = ResourcePermission.name and ");
            sb.append("ResourceAction.actionId = 'APPROVE_ARTICLE' and ");
            sb.append("ResourcePermission.scope = 4 and ");
            sb.append("ResourcePermission.actionIds >= ");
            sb.append("ResourceAction.bitwiseValue and ");
            sb.append("mod((ResourcePermission.actionIds / ");
            sb.append("ResourceAction.bitwiseValue), 2) = 1");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                long roleId = rs.getLong("roleId");
                long groupId = GetterUtil.getLong((String)rs.getString("primKey"));
                this.assignSingleApproverWorkflowRoles(companyId, roleId, groupId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

