/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_2;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeNestedPortlets
extends UpgradeProcess {
    private static final String _GET_LAYOUT = "select plid, typeSettings from Layout where typeSettings like '%nested-column-ids=118_INSTANCE_%'";
    private static final int _UNDERLINE_COUNT = StringUtil.count((String)"_INSTANCE_", (String)"_") + 1;
    private static Pattern _pattern = Pattern.compile("(118_INSTANCE_[^_,\\s=]+_)([^_,\\s=]+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpgrade() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement(_GET_LAYOUT);
            rs = ps.executeQuery();
            while (rs.next()) {
                String typeSettings;
                long plid = rs.getLong("plid");
                String newTypeSettings = typeSettings = rs.getString("typeSettings");
                Matcher matcher = _pattern.matcher(typeSettings);
                while (matcher.find()) {
                    String nestedColumnIds = matcher.group();
                    int underlineCount = StringUtil.count((String)nestedColumnIds, (String)"_");
                    if (underlineCount != _UNDERLINE_COUNT) continue;
                    String newNestedColumnIds = "_" + matcher.group(1) + "_" + matcher.group(2);
                    newTypeSettings = StringUtil.replace((String)newTypeSettings, (String)nestedColumnIds, (String)newNestedColumnIds);
                }
                if (newTypeSettings.equals(typeSettings)) continue;
                this.updateLayout(plid, newTypeSettings);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLayout(long plid, String typeSettings) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);
            ps.setString(1, typeSettings);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }
}

