/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_2;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.wiki.model.WikiPage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeExpando
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeExpando.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRow(long rowId, long companyId, long tableId, long classPK) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("insert into ExpandoRow (rowId_, companyId, tableId, classPK) values (?, ?, ?, ?)");
            ps.setLong(1, rowId);
            ps.setLong(2, companyId);
            ps.setLong(3, tableId);
            ps.setLong(4, classPK);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addValue(long valueId, long companyId, long tableId, long columnId, long rowId, long classNameId, long classPK, String data) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("insert into ExpandoValue (valueId, companyId, tableId, columnId, rowId_, classNameId, classPK, data_) values (?, ?, ?, ?, ?, ?, ?, ?)");
            ps.setLong(1, valueId);
            ps.setLong(2, companyId);
            ps.setLong(3, tableId);
            ps.setLong(4, columnId);
            ps.setLong(5, rowId);
            ps.setLong(6, classNameId);
            ps.setLong(7, classPK);
            ps.setString(8, data);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void doUpgrade() throws Exception {
        this.updateTables(JournalArticle.class.getName(), "JournalArticle", "id_");
        this.updateTables(WikiPage.class.getName(), "WikiPage", "pageId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasRow(long companyId, long tableId, long classPK) throws Exception {
        boolean bl;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block4: {
            boolean bl2;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select count(*) from ExpandoRow where companyId = ? and tableId = ? and classPK = ?");
                ps.setLong(1, companyId);
                ps.setLong(2, tableId);
                ps.setLong(3, classPK);
                rs = ps.executeQuery();
                while (rs.next()) {
                    int count = rs.getInt(1);
                    if (count <= 0) continue;
                    bl = true;
                    break block4;
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return bl2;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasValue(long companyId, long tableId, long columnId, long rowId) throws Exception {
        boolean bl;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block4: {
            boolean bl2;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select count(*) from ExpandoValue where companyId = ? and tableId = ? and columnId = ? and rowId_ = ?");
                ps.setLong(1, companyId);
                ps.setLong(2, tableId);
                ps.setLong(3, columnId);
                ps.setLong(4, rowId);
                rs = ps.executeQuery();
                while (rs.next()) {
                    int count = rs.getInt(1);
                    if (count <= 0) continue;
                    bl = true;
                    break block4;
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return bl2;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRow(long companyId, long classPK, String tableName, long tableId, String columnName, long rowId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select " + columnName + " from " + tableName + " where " + "resourcePrimKey = ?");
            ps.setLong(1, classPK);
            rs = ps.executeQuery();
            boolean delete = false;
            while (rs.next()) {
                long newClassPK = rs.getLong(columnName);
                delete = true;
                if (this.hasRow(companyId, tableId, newClassPK)) continue;
                long newRowId = this.increment();
                this.addRow(newRowId, companyId, tableId, newClassPK);
                this.updateValues(classPK, newClassPK, tableId, rowId, newRowId);
            }
            if (delete) {
                this.runSQL("delete from ExpandoRow where rowId_ = " + rowId);
                this.runSQL("delete from ExpandoValue where rowId_ = " + rowId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRows(String tableName, long tableId, String columnName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select * from ExpandoRow where tableId = ?");
            ps.setLong(1, tableId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long rowId = rs.getLong("rowId_");
                long companyId = rs.getLong("companyId");
                long classPK = rs.getLong("classPK");
                this.updateRow(companyId, classPK, tableName, tableId, columnName, rowId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTables(String className, String tableName, String columnName) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Upgrading " + tableName));
        }
        long classNameId = PortalUtil.getClassNameId((String)className);
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select * from ExpandoTable where classNameId = ? and name = ?");
            ps.setLong(1, classNameId);
            ps.setString(2, "CUSTOM_FIELDS");
            rs = ps.executeQuery();
            while (rs.next()) {
                long tableId = rs.getLong("tableId");
                this.updateRows(tableName, tableId, columnName);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateValues(long classPK, long newClassPK, long tableId, long rowId, long newRowId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select * from ExpandoValue where tableId = ? and rowId_ = ? and classPK = ?");
            ps.setLong(1, tableId);
            ps.setLong(2, rowId);
            ps.setLong(3, classPK);
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                long columnId = rs.getLong("columnId");
                long classNameId = rs.getLong("classNameId");
                String data = rs.getString("data_");
                if (this.hasValue(companyId, tableId, columnId, newRowId)) continue;
                long newValueId = this.increment();
                this.addValue(newValueId, companyId, tableId, columnId, newRowId, classNameId, newClassPK, data);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

