/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_8_to_6_0_5;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.upgrade.v5_2_8_to_6_0_5.util.DLFileEntryTable;
import com.liferay.portal.upgrade.v5_2_8_to_6_0_5.util.DLFileVersionTable;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileEntryNameUpgradeColumnImpl;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileEntryTitleUpgradeColumnImpl;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileEntryVersionUpgradeColumnImpl;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileRankTable;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileShortcutTable;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeDocumentLibrary.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileVersion(long groupId, long companyId, long userId, String userName, long folderId, String name, double version, int size) throws Exception {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(5);
            sb.append("insert into DLFileVersion (fileVersionId, groupId, ");
            sb.append("companyId, userId, userName, createDate, folderId, ");
            sb.append("name, version, size_, status, statusByUserId, ");
            sb.append("statusByUserName, statusDate) values (?, ?, ?, ?, ?, ");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setLong(1, this.increment());
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, userId);
            ps.setString(5, userName);
            ps.setTimestamp(6, now);
            ps.setLong(7, folderId);
            ps.setString(8, name);
            ps.setDouble(9, version);
            ps.setInt(10, size);
            ps.setInt(11, 0);
            ps.setLong(12, userId);
            ps.setString(13, userName);
            ps.setTimestamp(14, now);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpgrade() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select * from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                String newName;
                long companyId = rs.getLong("companyId");
                long groupId = rs.getLong("groupId");
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                long repositoryId = folderId;
                if (repositoryId == 0L) {
                    repositoryId = groupId;
                }
                if ((newName = DLFileEntryNameUpgradeColumnImpl.getNewName(name)).equals(name)) continue;
                try {
                    DLStoreUtil.updateFile((long)companyId, (long)repositoryId, (String)name, (String)newName);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to update file for " + name), (Throwable)e);
                }
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        this.synchronizeFileVersions();
        DLFileEntryNameUpgradeColumnImpl nameColumn = new DLFileEntryNameUpgradeColumnImpl("name");
        DLFileEntryTitleUpgradeColumnImpl titleColumn = new DLFileEntryTitleUpgradeColumnImpl((UpgradeColumn)nameColumn, "title");
        DLFileEntryVersionUpgradeColumnImpl versionColumn = new DLFileEntryVersionUpgradeColumnImpl("version");
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileEntry", (Object[][])DLFileEntryTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[]{nameColumn, titleColumn, versionColumn});
        upgradeTable.setCreateSQL("create table DLFileEntry (uuid_ VARCHAR(75) null,fileEntryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,versionUserId LONG,versionUserName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,folderId LONG,name VARCHAR(255) null,extension VARCHAR(75) null,title VARCHAR(255) null,description STRING null,extraSettings TEXT null,version VARCHAR(75) null,size_ LONG,readCount INTEGER)");
        upgradeTable.setIndexesSQL(DLFileEntryTable.TABLE_SQL_ADD_INDEXES);
        upgradeTable.updateTable();
        upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileRank", (Object[][])DLFileRankTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[]{nameColumn});
        upgradeTable.setCreateSQL("create table DLFileRank (fileRankId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,createDate DATE null,folderId LONG,name VARCHAR(255) null)");
        upgradeTable.setIndexesSQL(DLFileRankTable.TABLE_SQL_ADD_INDEXES);
        upgradeTable.updateTable();
        DLFileEntryNameUpgradeColumnImpl toNameColumn = new DLFileEntryNameUpgradeColumnImpl("toName");
        upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileShortcut", (Object[][])DLFileShortcutTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[]{toNameColumn});
        upgradeTable.setCreateSQL("create table DLFileShortcut (uuid_ VARCHAR(75) null,fileShortcutId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,folderId LONG,toFolderId LONG,toName VARCHAR(255) null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)");
        upgradeTable.setIndexesSQL(DLFileShortcutTable.TABLE_SQL_ADD_INDEXES);
        upgradeTable.updateTable();
        upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileVersion", (Object[][])DLFileVersionTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[]{nameColumn, versionColumn});
        upgradeTable.setCreateSQL(StringUtil.replace((String)"create table DLFileVersion (fileVersionId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,folderId LONG,name VARCHAR(255) null,extension VARCHAR(75) null,title VARCHAR(75) null,description STRING null,changeLog VARCHAR(75) null,extraSettings VARCHAR(75) null,version VARCHAR(75) null,size_ LONG,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)", (String[])new String[]{",extraSettings VARCHAR(75) null", ",title VARCHAR(75) null"}, (String[])new String[]{",extraSettings STRING null", ",title VARCHAR(255) null"}));
        upgradeTable.setIndexesSQL(DLFileVersionTable.TABLE_SQL_ADD_INDEXES);
        upgradeTable.updateTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronizeFileVersions() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(5);
            sb.append("select * from DLFileEntry dlFileEntry where version ");
            sb.append("not in (select version from DLFileVersion ");
            sb.append("dlFileVersion where (dlFileVersion.folderId = ");
            sb.append("dlFileEntry.folderId) and (dlFileVersion.name = ");
            sb.append("dlFileEntry.name))");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                long groupId = rs.getLong("groupId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                double version = rs.getDouble("version");
                int size = rs.getInt("size_");
                this.addFileVersion(groupId, companyId, userId, userName, folderId, name, version, size);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }
}

