/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.portlet.PortletPreferences;

public class UpgradeAssetPublisherManualEntries
extends BaseUpgradePortletPreferences {
    public static void upgradeToAssetEntryIdElement(Element rootElement) {
        Element assetIdElement = rootElement.element("asset-id");
        if (assetIdElement != null) {
            String assetEntryId = assetIdElement.getText();
            Element assetEntryIdElement = rootElement.addElement("assetEntryId");
            assetEntryIdElement.addText(assetEntryId);
            rootElement.remove(assetIdElement);
        }
    }

    public static void upgradeToAssetEntryTypeElement(Element rootElement) {
        Element assetTypeElement = rootElement.element("asset-type");
        if (assetTypeElement != null) {
            String assetEntryType = assetTypeElement.getText();
            Element assetEntryTypeElement = rootElement.addElement("assetEntryType");
            assetEntryTypeElement.addText(assetEntryType);
            rootElement.remove(assetTypeElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeToAssetEntryUuidElement(Element rootElement) throws Exception {
        Element assetEntryIdElement = rootElement.element("assetEntryId");
        long assetEntryId = GetterUtil.getLong((String)assetEntryIdElement.getText());
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select classUuid from AssetEntry where entryId = ?");
            ps.setLong(1, assetEntryId);
            rs = ps.executeQuery();
            if (rs.next()) {
                String classUuid = rs.getString("classUuid");
                Element assetEntryUuidElement = rootElement.addElement("assetEntryUuid");
                assetEntryUuidElement.addText(classUuid);
                rootElement.remove(assetEntryIdElement);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected String[] getAssetEntryXmls(String[] manualEntries) throws Exception {
        String[] assetEntryXmls = new String[manualEntries.length];
        for (int i = 0; i < manualEntries.length; ++i) {
            String manualEntry = manualEntries[i];
            Document document = SAXReaderUtil.read((String)manualEntry);
            Element rootElement = document.getRootElement();
            UpgradeAssetPublisherManualEntries.upgradeToAssetEntryIdElement(rootElement);
            UpgradeAssetPublisherManualEntries.upgradeToAssetEntryUuidElement(rootElement);
            UpgradeAssetPublisherManualEntries.upgradeToAssetEntryTypeElement(rootElement);
            assetEntryXmls[i] = document.formattedString("");
        }
        return assetEntryXmls;
    }

    protected String getUpdatePortletPreferencesWhereClause() {
        StringBundler sb = new StringBundler(5);
        sb.append("(portletId like '101_INSTANCE_%') and ((preferences like ");
        sb.append("'%<preference><name>selection-style</name><value>manual");
        sb.append("</value></preference>%') OR (preferences like ");
        sb.append("'%<preference><name>selectionStyle</name><value>manual");
        sb.append("</value></preference>%'))");
        return sb.toString();
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        Object[] manualEntries;
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        Object[] assetEntryXmls = portletPreferences.getValues("asset-entry-xml", new String[0]);
        if (ArrayUtil.isEmpty((Object[])assetEntryXmls)) {
            assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        }
        if (ArrayUtil.isEmpty((Object[])(manualEntries = portletPreferences.getValues("manual-entries", new String[0])))) {
            manualEntries = portletPreferences.getValues("manualEntries", new String[0]);
        }
        if (ArrayUtil.isEmpty((Object[])assetEntryXmls) && ArrayUtil.isNotEmpty((Object[])manualEntries)) {
            assetEntryXmls = this.getAssetEntryXmls((String[])manualEntries);
            portletPreferences.setValues("asset-entry-xml", (String[])assetEntryXmls);
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }
}

