/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class UpgradeMVCC
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeMVCC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpgrade() throws Exception {
        Connection connection = null;
        try {
            connection = DataAccess.getUpgradeOptimizedConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            List<Element> classElements = this.getClassElements();
            for (Element classElement : classElements) {
                if (classElement.element("version") == null) continue;
                this.upgradeMVCC(databaseMetaData, classElement);
            }
        }
        finally {
            DataAccess.cleanUp((Connection)connection);
        }
    }

    protected List<Element> getClassElements() throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("META-INF/portal-hbm.xml");
        Document document = SAXReaderUtil.read((InputStream)inputStream);
        Element rootElement = document.getRootElement();
        return rootElement.elements("class");
    }

    protected String normalizeName(String name, DatabaseMetaData databaseMetaData) throws SQLException {
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            return StringUtil.toLowerCase((String)name);
        }
        if (databaseMetaData.storesUpperCaseIdentifiers()) {
            return StringUtil.toUpperCase((String)name);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgradeMVCC(DatabaseMetaData databaseMetaData, Element classElement) throws Exception {
        String table = classElement.attributeValue("table");
        table = this.normalizeName(table, databaseMetaData);
        ResultSet tableResultSet = databaseMetaData.getTables(null, null, table, null);
        try {
            if (!tableResultSet.next()) {
                _log.error((Object)("Table " + table + " does not exist"));
                return;
            }
            ResultSet columnResultSet = databaseMetaData.getColumns(null, null, table, this.normalizeName("mvccVersion", databaseMetaData));
            try {
                if (columnResultSet.next()) {
                    return;
                }
                this.runSQL("alter table " + table + " add mvccVersion LONG default 0");
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Added column mvccVersion to table " + table));
                }
            }
            finally {
                DataAccess.cleanUp((ResultSet)columnResultSet);
            }
        }
        finally {
            DataAccess.cleanUp((ResultSet)tableResultSet);
        }
    }
}

