/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.typeconverter;

import jodd.typeconverter.ConvertBean;
import jodd.typeconverter.TypeConverter;
import jodd.util.CsvUtil;

public class NumberArrayConverter
implements TypeConverter<Number[]> {
    protected ConvertBean _convertBean;

    public NumberArrayConverter(ConvertBean convertBean) {
        this._convertBean = convertBean;
    }

    public Number[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (type == String.class) {
                Object[] values = CsvUtil.toStringArray((String)value.toString());
                return this.convertArray(values);
            }
            return new Number[]{this._convertBean.toBigDecimal(value)};
        }
        Class<?> componentType = type.getComponentType();
        if (componentType.isPrimitive()) {
            if (type == boolean[].class) {
                boolean[] values = (boolean[])value;
                Number[] results = new Number[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i] ? 1 : 0;
                }
                return results;
            }
            if (type == byte[].class) {
                byte[] values = (byte[])value;
                Number[] results = new Number[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == double[].class) {
                double[] values = (double[])value;
                Number[] results = new Number[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == float[].class) {
                float[] values = (float[])value;
                Number[] results = new Number[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = Float.valueOf(values[i]);
                }
                return results;
            }
            if (type == int[].class) {
                int[] values = (int[])value;
                Number[] results = new Number[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == long[].class) {
                long[] values = (long[])value;
                Number[] results = new Number[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == short[].class) {
                short[] values = (short[])value;
                Number[] results = new Number[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
        }
        return this.convertArray((Object[])value);
    }

    protected Number[] convertArray(Object[] values) {
        Number[] results = new Number[values.length];
        for (int i = 0; i < values.length; ++i) {
            results[i] = this._convertBean.toBigDecimal(values[i]);
        }
        return results;
    }
}

