/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.typeconverter;

import java.util.Date;
import jodd.typeconverter.ConvertBean;
import jodd.typeconverter.TypeConverter;
import jodd.util.CsvUtil;

public class DateArrayConverter
implements TypeConverter<Date[]> {
    private ConvertBean _convertBean;

    public DateArrayConverter(ConvertBean convertBean) {
        this._convertBean = convertBean;
    }

    public Date[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (type == String.class) {
                Object[] values = CsvUtil.toStringArray((String)value.toString());
                return this.convertArray(values);
            }
            return new Date[]{this._convertBean.toDate(value)};
        }
        Class<?> componentType = type.getComponentType();
        if (componentType.isPrimitive() && type == long[].class) {
            long[] values = (long[])value;
            Date[] results = new Date[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = this._convertBean.toDate((Object)values[i]);
            }
            return results;
        }
        return this.convertArray((Object[])value);
    }

    protected Date[] convertArray(Object[] values) {
        Date[] results = new Date[values.length];
        for (int i = 0; i < values.length; ++i) {
            results[i] = this._convertBean.toDate(values[i]);
        }
        return results;
    }
}

