/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.tools.ComparableRoute;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import com.liferay.util.ContentUtil;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLSourceProcessor
extends BaseSourceProcessor {
    private static Pattern _commentPattern1 = Pattern.compile(">\n\t+<!--[\n ]");
    private static Pattern _commentPattern2 = Pattern.compile("[\t ]-->\n[\t<]");
    private List<String> _columnNames;
    private List<String> _friendlyUrlRoutesSortExclusions;
    private List<String> _numericalPortletNameElementExclusions;
    private Pattern _poshiClosingTagPattern = Pattern.compile("</[^>/]*>");
    private Pattern _poshiCommandsPattern = Pattern.compile("\\<command.*name=\\\"([^\\\"]*)\\\".*\\>[\\s\\S]*?\\</command\\>[\\n|\\t]*?(?:[^(?:/\\>)]*?--\\>)*+");
    private Pattern _poshiElementWithNoChildPattern = Pattern.compile("\\\"[\\s]*\\>[\\n\\s\\t]*\\</[a-z\\-]+>");
    private Pattern _poshiEndLinesAfterClosingElementPattern = Pattern.compile("(\\</[a-z\\-]+>)(\\n+)\\t*\\<[a-z]+");
    private Pattern _poshiEndLinesBeforeClosingElementPattern = Pattern.compile("(\\n+)(\\t*</[a-z\\-]+>)");
    private Pattern _poshiEndLinesPattern = Pattern.compile("\\>\\n\\n\\n+(\\t*\\<)");
    private Pattern _poshiOpeningTagPattern = Pattern.compile("<[^/][^>]*[^/]>");
    private Pattern _poshiQuoteWithSlashPattern = Pattern.compile("\"[^\"]*\\>[^\"]*\"");
    private Pattern _poshiSetUpPattern = Pattern.compile("\\n[\\t]++\\<set-up\\>([\\s\\S]*?)\\</set-up\\>[\\n|\\t]*?(?:[^(?:/\\>)]*?--\\>)*+\\n");
    private Pattern _poshiTabsPattern = Pattern.compile("\\n*([ \\t]*<).*");
    private Pattern _poshiTearDownPattern = Pattern.compile("\\n[\\t]++\\<tear-down\\>([\\s\\S]*?)\\</tear-down\\>[\\n|\\t]*?(?:[^(?:/\\>)]*?--\\>)*+\\n");
    private Pattern _poshiVariableLinePattern = Pattern.compile("([\\t]*+)(\\<var name=\\\"([^\\\"]*)\\\".*?/\\>.*+(?:\\</var\\>)??)");
    private Pattern _poshiVariablesBlockPattern = Pattern.compile("((?:[\\t]*+\\<var.*?\\>\\n[\\t]*+){2,}?)(?:(?:\\n){1,}+|\\</execute\\>)");
    private Pattern _poshiWholeTagPattern = Pattern.compile("<[^\\>^/]*\\/>");
    private String _tablesContent;
    private List<String> _xmlExclusions;

    public static String formatXML(String content) {
        String newContent = StringUtil.replace((String)content, (String)"\"/>\n", (String)"\" />\n");
        while (true) {
            Matcher matcher;
            if ((matcher = _commentPattern1.matcher(newContent)).find()) {
                newContent = StringUtil.replaceFirst((String)newContent, (String)">\n", (String)">\n\n", (int)matcher.start());
                continue;
            }
            matcher = _commentPattern2.matcher(newContent);
            if (!matcher.find()) break;
            newContent = StringUtil.replaceFirst((String)newContent, (String)"-->\n", (String)"-->\n\n", (int)matcher.start());
        }
        return newContent;
    }

    protected void checkServiceXMLExceptions(String fileName, Element rootElement) {
        Element exceptionsElement = rootElement.element("exceptions");
        if (exceptionsElement == null) {
            return;
        }
        List exceptionElements = exceptionsElement.elements("exception");
        String previousException = "";
        for (Element exceptionElement : exceptionElements) {
            String exception = exceptionElement.getStringValue();
            if (Validator.isNotNull((String)previousException) && previousException.compareToIgnoreCase(exception) > 0) {
                XMLSourceProcessor.processErrorMessage(fileName, "sort: " + fileName + " " + exception);
            }
            previousException = exception;
        }
    }

    protected void checkServiceXMLFinders(String fileName, Element entityElement, String entityName) throws Exception {
        this._columnNames = this.getColumnNames(fileName, entityName);
        FinderElementComparator finderElementComparator = new FinderElementComparator();
        List finderElements = entityElement.elements("finder");
        for (int i = 1; i < finderElements.size(); ++i) {
            Element finderElement = (Element)finderElements.get(i);
            Element previousFinderElement = (Element)finderElements.get(i - 1);
            if (finderElementComparator.compare(previousFinderElement, finderElement) <= 0) continue;
            String finderName = finderElement.attributeValue("name");
            XMLSourceProcessor.processErrorMessage(fileName, "order: " + fileName + " " + entityName + " " + finderName);
        }
    }

    protected void checkServiceXMLReferences(String fileName, Element entityElement, String entityName) {
        String previousReferenceEntity = "";
        String previousReferencePackagePath = "";
        List referenceElements = entityElement.elements("reference");
        for (Element referenceElement : referenceElements) {
            String referenceEntity = referenceElement.attributeValue("entity");
            String referencePackagePath = referenceElement.attributeValue("package-path");
            if (Validator.isNotNull((String)previousReferencePackagePath) && (previousReferencePackagePath.compareToIgnoreCase(referencePackagePath) > 0 || previousReferencePackagePath.equals(referencePackagePath) && previousReferenceEntity.compareToIgnoreCase(referenceEntity) > 0)) {
                XMLSourceProcessor.processErrorMessage(fileName, "sort: " + fileName + " " + entityName + " " + referenceEntity);
            }
            previousReferenceEntity = referenceEntity;
            previousReferencePackagePath = referencePackagePath;
        }
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        if (XMLSourceProcessor.isExcluded(this._xmlExclusions, absolutePath)) {
            return content;
        }
        String newContent = content;
        if (!fileName.contains("/build")) {
            newContent = this.trimContent(newContent, false);
        }
        if (fileName.contains("/build") && !fileName.contains("/tools/")) {
            newContent = this.formatAntXML(fileName, newContent);
        } else if (fileName.endsWith("structures.xml")) {
            newContent = this.formatDDLStructuresXML(newContent);
        } else if (fileName.endsWith("routes.xml")) {
            newContent = this.formatFriendlyURLRoutesXML(absolutePath, newContent);
        } else if (fileName.endsWith("/liferay-portlet.xml") || portalSource && fileName.endsWith("/portlet-custom.xml") || !portalSource && fileName.endsWith("/portlet.xml")) {
            newContent = this.formatPortletXML(fileName, absolutePath, newContent);
        } else if (portalSource && (fileName.endsWith(".action") || fileName.endsWith(".function") || fileName.endsWith(".macro") || fileName.endsWith(".testcase") || fileName.endsWith(".testxml"))) {
            newContent = this.formatPoshiXML(fileName, newContent);
        } else if (fileName.endsWith("/service.xml")) {
            this.formatServiceXML(fileName, newContent);
        } else if (portalSource && fileName.endsWith("/struts-config.xml")) {
            this.formatStrutsConfigXML(fileName, newContent);
        } else if (portalSource && fileName.endsWith("/tiles-defs.xml")) {
            this.formatTilesDefsXML(fileName, newContent);
        } else if (portalSource && fileName.endsWith("portal-web/docroot/WEB-INF/web.xml") || !portalSource && fileName.endsWith("/web.xml")) {
            newContent = this.formatWebXML(fileName, newContent);
        }
        return XMLSourceProcessor.formatXML(newContent);
    }

    protected String fixAntXMLProjectName(String fileName, String content) {
        int x = 0;
        if (fileName.endsWith("-ext/build.xml")) {
            if (fileName.startsWith("ext/")) {
                x = 4;
            }
        } else if (fileName.endsWith("-hook/build.xml")) {
            if (fileName.startsWith("hooks/")) {
                x = 6;
            }
        } else if (fileName.endsWith("-layouttpl/build.xml")) {
            if (fileName.startsWith("layouttpl/")) {
                x = 10;
            }
        } else if (fileName.endsWith("-portlet/build.xml")) {
            if (fileName.startsWith("portlets/")) {
                x = 9;
            }
        } else if (fileName.endsWith("-theme/build.xml")) {
            if (fileName.startsWith("themes/")) {
                x = 7;
            }
        } else if (fileName.endsWith("-web/build.xml") && !fileName.endsWith("/ext-web/build.xml")) {
            if (fileName.startsWith("webs/")) {
                x = 5;
            }
        } else {
            return content;
        }
        if (content.contains("<project>")) {
            return content;
        }
        int y = fileName.indexOf("/", x);
        String correctProjectElementText = "<project name=\"" + fileName.substring(x, y) + "\"";
        if (!content.contains(correctProjectElementText)) {
            x = content.indexOf("<project name=\"");
            y = content.indexOf("\"", x) + 1;
            y = content.indexOf("\"", y) + 1;
            content = content.substring(0, x) + correctProjectElementText + content.substring(y);
            XMLSourceProcessor.processErrorMessage(fileName, fileName + " has an incorrect project name");
        }
        return content;
    }

    protected String fixPoshiXMLElementWithNoChild(String content) {
        Matcher matcher = this._poshiElementWithNoChildPattern.matcher(content);
        while (matcher.find()) {
            content = StringUtil.replace((String)content, (String)matcher.group(), (String)"\" />");
        }
        return content;
    }

    protected String fixPoshiXMLEndLines(String content) {
        Matcher matcher = this._poshiEndLinesPattern.matcher(content);
        while (matcher.find()) {
            String statement = matcher.group();
            String newStatement = StringUtil.replace((String)statement, (String)matcher.group(), (String)(">\n\n" + matcher.group(1)));
            content = StringUtil.replace((String)content, (String)statement, (String)newStatement);
        }
        return content;
    }

    protected String fixPoshiXMLEndLinesAfterClosingElement(String content) {
        Matcher matcher = this._poshiEndLinesAfterClosingElementPattern.matcher(content);
        while (matcher.find()) {
            String newStatement;
            String statement = matcher.group();
            String closingElementName = matcher.group(1);
            if (StringUtil.equalsIgnoreCase((String)"</and>", (String)closingElementName) || StringUtil.equalsIgnoreCase((String)"</elseif>", (String)closingElementName) || StringUtil.equalsIgnoreCase((String)"</not>", (String)closingElementName) || StringUtil.equalsIgnoreCase((String)"</or>", (String)closingElementName) || StringUtil.equalsIgnoreCase((String)"</then>", (String)closingElementName)) {
                newStatement = StringUtil.replace((String)statement, (String)matcher.group(2), (String)"\n");
                content = StringUtil.replace((String)content, (String)statement, (String)newStatement);
                continue;
            }
            if (StringUtil.equalsIgnoreCase((String)"</var>", (String)closingElementName)) continue;
            newStatement = StringUtil.replace((String)statement, (String)matcher.group(2), (String)"\n\n");
            content = StringUtil.replace((String)content, (String)statement, (String)newStatement);
        }
        return content;
    }

    protected String fixPoshiXMLEndLinesBeforeClosingElement(String content) {
        Matcher matcher = this._poshiEndLinesBeforeClosingElementPattern.matcher(content);
        while (matcher.find()) {
            String statement = matcher.group();
            String newStatement = StringUtil.replace((String)statement, (String)matcher.group(1), (String)"\n");
            content = StringUtil.replace((String)content, (String)statement, (String)newStatement);
        }
        return content;
    }

    protected String fixPoshiXMLNumberOfTabs(String content) {
        Matcher matcher = this._poshiTabsPattern.matcher(content);
        int tabCount = 0;
        boolean ignoredCdataBlock = false;
        boolean ignoredCommentBlock = false;
        while (matcher.find()) {
            String statement = matcher.group();
            Matcher quoteWithSlashMatcher = this._poshiQuoteWithSlashPattern.matcher(statement);
            String fixedQuoteStatement = statement;
            if (quoteWithSlashMatcher.find()) {
                fixedQuoteStatement = StringUtil.replace((String)statement, (String)quoteWithSlashMatcher.group(), (String)"\"\"");
            }
            Matcher closingTagMatcher = this._poshiClosingTagPattern.matcher(fixedQuoteStatement);
            Matcher openingTagMatcher = this._poshiOpeningTagPattern.matcher(fixedQuoteStatement);
            Matcher wholeTagMatcher = this._poshiWholeTagPattern.matcher(fixedQuoteStatement);
            if (!(!closingTagMatcher.find() || openingTagMatcher.find() || wholeTagMatcher.find() || statement.contains("<!--") || statement.contains("-->") || statement.contains("<![CDATA[") || statement.contains("]]>"))) {
                --tabCount;
            }
            if (statement.contains("]]>")) {
                ignoredCdataBlock = false;
            } else if (statement.contains("<![CDATA[")) {
                ignoredCdataBlock = true;
            }
            if (statement.contains("-->")) {
                ignoredCommentBlock = false;
            } else if (statement.contains("<!--")) {
                ignoredCommentBlock = true;
            }
            if (!ignoredCommentBlock && !ignoredCdataBlock) {
                StringBundler sb = new StringBundler(tabCount + 1);
                for (int i = 0; i < tabCount; ++i) {
                    sb.append("\t");
                }
                sb.append("<");
                String replacement = sb.toString();
                if (!replacement.equals(matcher.group(1))) {
                    String newStatement = StringUtil.replace((String)statement, (String)matcher.group(1), (String)replacement);
                    return StringUtil.replaceFirst((String)content, (String)statement, (String)newStatement, (int)matcher.start());
                }
            }
            if (!openingTagMatcher.find() || closingTagMatcher.find() || wholeTagMatcher.find() || statement.contains("<!--") || statement.contains("-->") || statement.contains("<![CDATA[") || statement.contains("]]>")) continue;
            ++tabCount;
        }
        return content;
    }

    @Override
    protected void format() throws Exception {
        String[] excludes = new String[]{"**\\.bnd\\**", "**\\.idea\\**", "**\\.ivy\\**", "portal-impl\\**\\*.action", "portal-impl\\**\\*.function", "portal-impl\\**\\*.macro", "portal-impl\\**\\*.testcase"};
        String[] includes = new String[]{"**\\*.action", "**\\*.function", "**\\*.macro", "**\\*.testcase", "**\\*.xml"};
        this._friendlyUrlRoutesSortExclusions = this.getPropertyList("friendly.url.routes.sort.excludes.files");
        this._numericalPortletNameElementExclusions = this.getPropertyList("numerical.portlet.name.element.excludes.files");
        this._xmlExclusions = this.getPropertyList("xml.excludes.files");
        List<String> fileNames = this.getFileNames(excludes, includes);
        for (String fileName : fileNames) {
            this.format(fileName);
        }
    }

    protected String formatAntXML(String fileName, String content) throws Exception {
        String newContent = this.trimContent(content, true);
        newContent = this.fixAntXMLProjectName(fileName, newContent);
        Document document = saxReaderUtil.read(newContent);
        Element rootElement = document.getRootElement();
        String previousName = "";
        List targetElements = rootElement.elements("target");
        for (Element targetElement : targetElements) {
            String name = targetElement.attributeValue("name");
            if (name.equals("Test")) {
                name = StringUtil.toLowerCase((String)name);
            }
            if (name.compareTo(previousName) < -1) {
                XMLSourceProcessor.processErrorMessage(fileName, fileName + " has an unordered target " + name);
                break;
            }
            previousName = name;
        }
        return newContent;
    }

    protected String formatDDLStructuresXML(String content) throws Exception {
        Document document = saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        rootElement.sortAttributes(true);
        rootElement.sortElementsByChildElement("structure", "name");
        List structureElements = rootElement.elements("structure");
        for (Element structureElement : structureElements) {
            Element structureRootElement = structureElement.element("root");
            structureRootElement.sortElementsByAttribute("dynamic-element", "name");
            List dynamicElementElements = structureRootElement.elements("dynamic-element");
            for (Element dynamicElementElement : dynamicElementElements) {
                Element metaDataElement = dynamicElementElement.element("meta-data");
                metaDataElement.sortElementsByAttribute("entry", "name");
            }
        }
        return document.formattedString();
    }

    protected String formatFriendlyURLRoutesXML(String absolutePath, String content) throws Exception {
        if (XMLSourceProcessor.isExcluded(this._friendlyUrlRoutesSortExclusions, absolutePath)) {
            return content;
        }
        Document document = saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        ArrayList<ComparableRoute> comparableRoutes = new ArrayList<ComparableRoute>();
        for (Element routeElement : rootElement.elements("route")) {
            String value;
            String name;
            String pattern = routeElement.elementText("pattern");
            ComparableRoute comparableRoute = new ComparableRoute(pattern);
            for (Element generatedParameterElement : routeElement.elements("generated-parameter")) {
                name = generatedParameterElement.attributeValue("name");
                value = generatedParameterElement.getText();
                comparableRoute.addGeneratedParameter(name, value);
            }
            for (Element ignoredParameterElement : routeElement.elements("ignored-parameter")) {
                name = ignoredParameterElement.attributeValue("name");
                comparableRoute.addIgnoredParameter(name);
            }
            for (Element implicitParameterElement : routeElement.elements("implicit-parameter")) {
                name = implicitParameterElement.attributeValue("name");
                value = implicitParameterElement.getText();
                comparableRoute.addImplicitParameter(name, value);
            }
            for (Element overriddenParameterElement : routeElement.elements("overridden-parameter")) {
                name = overriddenParameterElement.attributeValue("name");
                value = overriddenParameterElement.getText();
                comparableRoute.addOverriddenParameter(name, value);
            }
            comparableRoutes.add(comparableRoute);
        }
        Collections.sort(comparableRoutes);
        String mainReleaseVersion = this.getMainReleaseVersion();
        StringBundler sb = new StringBundler();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<!DOCTYPE routes PUBLIC \"-//Liferay//DTD Friendly URL ");
        sb.append("Routes ");
        sb.append(mainReleaseVersion);
        sb.append("//EN\" \"http://www.liferay.com/dtd/");
        sb.append("liferay-friendly-url-routes_");
        sb.append(StringUtil.replace((String)mainReleaseVersion, (String)".", (String)"_"));
        sb.append(".dtd\">\n\n<routes>\n");
        for (ComparableRoute comparableRoute : comparableRoutes) {
            sb.append("\t<route>\n");
            sb.append("\t\t<pattern>");
            sb.append(comparableRoute.getPattern());
            sb.append("</pattern>\n");
            Map<String, String> generatedParameters = comparableRoute.getGeneratedParameters();
            for (Map.Entry<String, String> entry : generatedParameters.entrySet()) {
                sb.append("\t\t<generated-parameter name=\"");
                sb.append(entry.getKey());
                sb.append("\">");
                sb.append(entry.getValue());
                sb.append("</generated-parameter>\n");
            }
            Set<String> ignoredParameters = comparableRoute.getIgnoredParameters();
            for (String entry : ignoredParameters) {
                sb.append("\t\t<ignored-parameter name=\"");
                sb.append(entry);
                sb.append("\" />\n");
            }
            Map<String, String> implicitParameters = comparableRoute.getImplicitParameters();
            for (Map.Entry<String, String> entry : implicitParameters.entrySet()) {
                sb.append("\t\t<implicit-parameter name=\"");
                sb.append(entry.getKey());
                sb.append("\">");
                sb.append(entry.getValue());
                sb.append("</implicit-parameter>\n");
            }
            Map<String, String> overriddenParameters = comparableRoute.getOverriddenParameters();
            for (Map.Entry<String, String> entry : overriddenParameters.entrySet()) {
                sb.append("\t\t<overridden-parameter name=\"");
                sb.append(entry.getKey());
                sb.append("\">");
                sb.append(entry.getValue());
                sb.append("</overridden-parameter>\n");
            }
            sb.append("\t</route>\n");
        }
        sb.append("</routes>");
        return sb.toString();
    }

    protected String formatPortletXML(String fileName, String absolutePath, String content) throws Exception {
        Document document = saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        rootElement.sortAttributes(true);
        boolean checkNumericalPortletNameElement = !XMLSourceProcessor.isExcluded(this._numericalPortletNameElementExclusions, absolutePath);
        List portletElements = rootElement.elements("portlet");
        for (Element portletElement : portletElements) {
            Element portletNameElement;
            String portletNameText;
            if (checkNumericalPortletNameElement && !Validator.isNumber((String)(portletNameText = (portletNameElement = portletElement.element("portlet-name")).getText()))) {
                XMLSourceProcessor.processErrorMessage(fileName, fileName + " contains a nonstandard portlet-name element " + portletNameText);
            }
            if (fileName.endsWith("/liferay-portlet.xml")) continue;
            portletElement.sortElementsByChildElement("init-param", "name");
            Element portletPreferencesElement = portletElement.element("portlet-preferences");
            if (portletPreferencesElement == null) continue;
            portletPreferencesElement.sortElementsByChildElement("preference", "name");
        }
        return document.formattedString();
    }

    protected String formatPoshiXML(String fileName, String content) throws Exception {
        content = this.sortPoshiAttributes(fileName, content);
        content = this.sortPoshiCommands(content);
        content = this.sortPoshiVariables(content);
        content = this.fixPoshiXMLElementWithNoChild(content);
        content = this.fixPoshiXMLEndLinesAfterClosingElement(content);
        content = this.fixPoshiXMLEndLinesBeforeClosingElement(content);
        content = this.fixPoshiXMLEndLines(content);
        return this.fixPoshiXMLNumberOfTabs(content);
    }

    protected void formatServiceXML(String fileName, String content) throws Exception {
        Document document = saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        List entityElements = rootElement.elements("entity");
        String previousEntityName = "";
        for (Element entityElement : entityElements) {
            String entityName = entityElement.attributeValue("name");
            if (Validator.isNotNull((String)previousEntityName) && previousEntityName.compareToIgnoreCase(entityName) > 0) {
                XMLSourceProcessor.processErrorMessage(fileName, "sort: " + fileName + " " + entityName);
            }
            this.checkServiceXMLFinders(fileName, entityElement, entityName);
            this.checkServiceXMLReferences(fileName, entityElement, entityName);
            previousEntityName = entityName;
        }
        this.checkServiceXMLExceptions(fileName, rootElement);
    }

    protected void formatStrutsConfigXML(String fileName, String content) throws Exception {
        Document document = saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        Element actionMappingsElement = rootElement.element("action-mappings");
        List actionElements = actionMappingsElement.elements("action");
        String previousPath = "";
        for (Element actionElement : actionElements) {
            String path = actionElement.attributeValue("path");
            if (Validator.isNotNull((String)previousPath) && previousPath.compareTo(path) > 0 && (!previousPath.startsWith("/portal/") || path.startsWith("/portal/"))) {
                XMLSourceProcessor.processErrorMessage(fileName, "sort: " + fileName + " " + path);
            }
            previousPath = path;
        }
    }

    protected void formatTilesDefsXML(String fileName, String content) throws Exception {
        Document document = saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        List definitionElements = rootElement.elements("definition");
        String previousName = "";
        for (Element definitionElement : definitionElements) {
            String name = definitionElement.attributeValue("name");
            if (Validator.isNotNull((String)previousName) && previousName.compareTo(name) > 0 && !previousName.equals("portlet")) {
                XMLSourceProcessor.processErrorMessage(fileName, "sort: " + fileName + " " + name);
            }
            previousName = name;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String formatWebXML(String fileName, String content) throws Exception {
        void var9_13;
        if (!portalSource) {
            String webXML = ContentUtil.get((String)"com/liferay/portal/deploy/dependencies/web.xml");
            if (content.equals(webXML)) {
                XMLSourceProcessor.processErrorMessage(fileName, fileName);
            }
            return content;
        }
        Properties properties = new Properties();
        String propertiesContent = fileUtil.read("./portal-impl/src/portal.properties");
        PropertiesUtil.load((Properties)properties, (String)propertiesContent);
        Object[] locales = StringUtil.split((String)properties.getProperty("locales"));
        Arrays.sort(locales);
        TreeSet<Object> urlPatterns = new TreeSet<Object>();
        Object[] arr$ = locales;
        int len$ = arr$.length;
        boolean bl = false;
        while (var9_13 < len$) {
            Object locale = arr$[var9_13];
            int pos = ((String)locale).indexOf("_");
            String string = ((String)locale).substring(0, pos);
            urlPatterns.add(string);
            urlPatterns.add(locale);
            ++var9_13;
        }
        StringBundler sb = new StringBundler(6 * urlPatterns.size());
        for (String string : urlPatterns) {
            sb.append("\t<servlet-mapping>\n");
            sb.append("\t\t<servlet-name>I18n Servlet</servlet-name>\n");
            sb.append("\t\t<url-pattern>/");
            sb.append(string);
            sb.append("/*</url-pattern>\n");
            sb.append("\t</servlet-mapping>\n");
        }
        int x = content.indexOf("<servlet-mapping>");
        x = content.indexOf("<servlet-name>I18n Servlet</servlet-name>", x);
        x = content.lastIndexOf("<servlet-mapping>", x) - 1;
        int n2 = content.lastIndexOf("<servlet-name>I18n Servlet</servlet-name>");
        n2 = content.indexOf("</servlet-mapping>", n2) + 19;
        String newContent = content.substring(0, x) + sb.toString() + content.substring(n2);
        x = newContent.indexOf("<security-constraint>");
        x = newContent.indexOf("<web-resource-name>/c/portal/protected</web-resource-name>", x);
        x = newContent.indexOf("<url-pattern>", x) - 3;
        int n4 = newContent.indexOf("<http-method>", x);
        n4 = newContent.lastIndexOf("</url-pattern>", n4) + 15;
        sb = new StringBundler(3 * urlPatterns.size() + 1);
        sb.append("\t\t\t<url-pattern>/c/portal/protected</url-pattern>\n");
        for (String string : urlPatterns) {
            sb.append("\t\t\t<url-pattern>/");
            sb.append(string);
            sb.append("/c/portal/protected</url-pattern>\n");
        }
        return newContent.substring(0, x) + sb.toString() + newContent.substring(n4);
    }

    protected List<String> getColumnNames(String fileName, String entityName) throws Exception {
        ArrayList<String> columnNames = new ArrayList<String>();
        Pattern pattern = Pattern.compile("create table " + entityName + "_? \\(\n([\\s\\S]*?)\n\\);");
        Matcher matcher = pattern.matcher(this.getTablesContent(fileName));
        if (!matcher.find()) {
            return columnNames;
        }
        String tableContent = matcher.group(1);
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(tableContent));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            line = StringUtil.trim((String)line);
            String columnName = line.substring(0, line.indexOf(" "));
            columnName = StringUtil.replace((String)columnName, (String)"_", (String)"");
            columnNames.add(columnName);
        }
        return columnNames;
    }

    protected String getTablesContent(String fileName) throws Exception {
        if (portalSource) {
            if (this._tablesContent == null) {
                this._tablesContent = this.getContent("sql/portal-tables.sql", 4);
            }
            return this._tablesContent;
        }
        int pos = fileName.lastIndexOf("/");
        return this.getContent(fileName.substring(0, pos) + "/sql/tables.sql", 1);
    }

    protected String sortPoshiAttributes(String fileName, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));){
            String line = null;
            int lineCount = 0;
            boolean sortAttributes = true;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineCount;
                String trimmedLine = StringUtil.trimLeading((String)line);
                if (sortAttributes) {
                    if (trimmedLine.startsWith("<") && trimmedLine.endsWith(">") && !trimmedLine.startsWith("<%") && !trimmedLine.startsWith("<!")) {
                        line = this.sortAttributes(fileName, line, lineCount, false);
                    } else if (trimmedLine.startsWith("<![CDATA[") && !trimmedLine.endsWith("]]>")) {
                        sortAttributes = false;
                    }
                } else if (trimmedLine.endsWith("]]>")) {
                    sortAttributes = true;
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    protected String sortPoshiCommands(String content) {
        Matcher matcher = this._poshiCommandsPattern.matcher(content);
        TreeMap<String, String> commandBlocksMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String previousName = "";
        boolean hasUnsortedCommands = false;
        while (matcher.find()) {
            String commandBlock = matcher.group();
            String commandName = matcher.group(1);
            commandBlocksMap.put(commandName, commandBlock);
            if (!hasUnsortedCommands && commandName.compareToIgnoreCase(previousName) < 0) {
                hasUnsortedCommands = true;
            }
            previousName = commandName;
        }
        if (!hasUnsortedCommands) {
            return content;
        }
        StringBundler sb = new StringBundler();
        matcher = this._poshiSetUpPattern.matcher(content);
        if (matcher.find()) {
            String setUpBlock = matcher.group();
            content = content.replace(setUpBlock, "");
            sb.append(setUpBlock);
        }
        if ((matcher = this._poshiTearDownPattern.matcher(content)).find()) {
            String tearDownBlock = matcher.group();
            content = content.replace(tearDownBlock, "");
            sb.append(tearDownBlock);
        }
        for (Map.Entry entry : commandBlocksMap.entrySet()) {
            sb.append("\n\t");
            sb.append((String)entry.getValue());
            sb.append("\n");
        }
        int x = content.indexOf("<command");
        int y = content.lastIndexOf("</command>");
        String commandBlock = content.substring(x, y);
        commandBlock = "\n\t" + commandBlock + "</command>\n";
        String newCommandBlock = sb.toString();
        return StringUtil.replaceFirst((String)content, (String)commandBlock, (String)newCommandBlock);
    }

    protected String sortPoshiVariables(String content) {
        Matcher matcher = this._poshiVariablesBlockPattern.matcher(content);
        while (matcher.find()) {
            String previousName = "";
            String tabs = "";
            TreeMap<String, String> variableLinesMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            String variableBlock = matcher.group(1);
            variableBlock = variableBlock.trim();
            Matcher variableLineMatcher = this._poshiVariableLinePattern.matcher(variableBlock);
            boolean hasUnsortedVariables = false;
            while (variableLineMatcher.find()) {
                if (tabs.equals("")) {
                    tabs = variableLineMatcher.group(1);
                }
                String variableLine = variableLineMatcher.group(2);
                String variableName = variableLineMatcher.group(3);
                variableLinesMap.put(variableName, variableLine);
                if (!hasUnsortedVariables && variableName.compareToIgnoreCase(previousName) < 0) {
                    hasUnsortedVariables = true;
                }
                previousName = variableName;
            }
            if (!hasUnsortedVariables) continue;
            StringBundler sb = new StringBundler();
            for (Map.Entry entry : variableLinesMap.entrySet()) {
                sb.append(tabs);
                sb.append((String)entry.getValue());
                sb.append("\n");
            }
            String newVariableBlock = sb.toString();
            newVariableBlock = newVariableBlock.trim();
            content = StringUtil.replaceFirst((String)content, (String)variableBlock, (String)newVariableBlock);
        }
        return content;
    }

    private class FinderElementComparator
    implements Comparator<Element> {
        private FinderElementComparator() {
        }

        @Override
        public int compare(Element finderElement1, Element finderElement2) {
            int finderColumnCount2;
            List finderColumnElements1 = finderElement1.elements("finder-column");
            List finderColumnElements2 = finderElement2.elements("finder-column");
            int finderColumnCount1 = finderColumnElements1.size();
            if (finderColumnCount1 != (finderColumnCount2 = finderColumnElements2.size())) {
                return finderColumnCount1 - finderColumnCount2;
            }
            for (int i = 0; i < finderColumnCount1; ++i) {
                int index2;
                Element finderColumnElement1 = (Element)finderColumnElements1.get(i);
                Element finderColumnElement2 = (Element)finderColumnElements2.get(i);
                String finderColumnName1 = finderColumnElement1.attributeValue("name");
                String finderColumnName2 = finderColumnElement2.attributeValue("name");
                int index1 = XMLSourceProcessor.this._columnNames.indexOf(finderColumnName1);
                if (index1 == (index2 = XMLSourceProcessor.this._columnNames.indexOf(finderColumnName2))) continue;
                return index1 - index2;
            }
            String finderName1 = finderElement1.attributeValue("name");
            String finderName2 = finderElement2.attributeValue("name");
            int startsWithWeight = StringUtil.startsWithWeight((String)finderName1, (String)finderName2);
            String strippedFinderName1 = finderName1.substring(startsWithWeight);
            String strippedFinderName2 = finderName2.substring(startsWithWeight);
            if (strippedFinderName1.startsWith("Gt") || strippedFinderName1.startsWith("Like") || strippedFinderName1.startsWith("Lt") || strippedFinderName1.startsWith("Not")) {
                if (!(strippedFinderName2.startsWith("Gt") || strippedFinderName2.startsWith("Like") || strippedFinderName2.startsWith("Lt") || strippedFinderName2.startsWith("Not"))) {
                    return 1;
                }
                return strippedFinderName1.compareTo(strippedFinderName2);
            }
            return 0;
        }
    }
}

