/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.tools.sourceformatter.CSSSourceProcessor;
import com.liferay.portal.tools.sourceformatter.FTLSourceProcessor;
import com.liferay.portal.tools.sourceformatter.JSPSourceProcessor;
import com.liferay.portal.tools.sourceformatter.JSSourceProcessor;
import com.liferay.portal.tools.sourceformatter.JavaSourceProcessor;
import com.liferay.portal.tools.sourceformatter.PropertiesSourceProcessor;
import com.liferay.portal.tools.sourceformatter.SHSourceProcessor;
import com.liferay.portal.tools.sourceformatter.SQLSourceProcessor;
import com.liferay.portal.tools.sourceformatter.SourceFormatterUtil;
import com.liferay.portal.tools.sourceformatter.SourceMismatchException;
import com.liferay.portal.tools.sourceformatter.SourceProcessor;
import com.liferay.portal.tools.sourceformatter.TLDSourceProcessor;
import com.liferay.portal.tools.sourceformatter.XMLSourceProcessor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class SourceFormatter {
    private boolean _autoFix;
    private Set<String> _errorMessages = new LinkedHashSet<String>();
    private SourceMismatchException _firstSourceMismatchException;
    private boolean _printErrors;
    private boolean _throwException;
    private boolean _useProperties;

    public static void main(String[] args) {
        try {
            SourceFormatter sourceFormatter = SourceFormatterUtil.create(false, false, true, true);
            sourceFormatter.format();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SourceFormatter(boolean useProperties, boolean throwException, boolean printErrors, boolean autoFix) throws Exception {
        this._useProperties = useProperties;
        this._throwException = throwException;
        this._printErrors = printErrors;
        this._autoFix = autoFix;
    }

    public void format() throws Exception {
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                try {
                    ArrayList sourceProcessors = new ArrayList();
                    sourceProcessors.add(CSSSourceProcessor.class.newInstance());
                    sourceProcessors.add(FTLSourceProcessor.class.newInstance());
                    sourceProcessors.add(JSPSourceProcessor.class.newInstance());
                    sourceProcessors.add(JSSourceProcessor.class.newInstance());
                    sourceProcessors.add(PropertiesSourceProcessor.class.newInstance());
                    sourceProcessors.add(SHSourceProcessor.class.newInstance());
                    sourceProcessors.add(SQLSourceProcessor.class.newInstance());
                    sourceProcessors.add(TLDSourceProcessor.class.newInstance());
                    for (SourceProcessor sourceProcessor : sourceProcessors) {
                        SourceFormatter.this._runSourceProcessor(sourceProcessor);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                try {
                    ArrayList sourceProcessors = new ArrayList();
                    sourceProcessors.add(JavaSourceProcessor.class.newInstance());
                    sourceProcessors.add(XMLSourceProcessor.class.newInstance());
                    for (SourceProcessor sourceProcessor : sourceProcessors) {
                        SourceFormatter.this._runSourceProcessor(sourceProcessor);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        if (this._throwException) {
            if (!this._errorMessages.isEmpty()) {
                throw new Exception(StringUtil.merge(this._errorMessages, (String)"\n"));
            }
            if (this._firstSourceMismatchException != null) {
                throw this._firstSourceMismatchException;
            }
        }
    }

    public Tuple format(String fileName) throws Exception {
        SourceProcessor sourceProcessor = null;
        if (fileName.endsWith(".testjava")) {
            sourceProcessor = (SourceProcessor)JavaSourceProcessor.class.newInstance();
        } else if (fileName.endsWith(".testsql")) {
            sourceProcessor = (SourceProcessor)SQLSourceProcessor.class.newInstance();
        } else if (fileName.endsWith(".testxml")) {
            sourceProcessor = (SourceProcessor)XMLSourceProcessor.class.newInstance();
        }
        if (sourceProcessor == null) {
            return null;
        }
        String newContent = sourceProcessor.format(fileName, this._useProperties, this._printErrors, this._autoFix);
        return new Tuple(new Object[]{newContent, sourceProcessor.getErrorMessages()});
    }

    private void _runSourceProcessor(SourceProcessor sourceProcessor) throws Exception {
        sourceProcessor.format(this._useProperties, this._printErrors, this._autoFix);
        this._errorMessages.addAll(sourceProcessor.getErrorMessages());
        if (this._firstSourceMismatchException == null) {
            this._firstSourceMismatchException = sourceProcessor.getFirstSourceMismatchException();
        }
    }
}

