/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import java.io.File;
import java.io.Reader;
import java.util.List;

public class SQLSourceProcessor
extends BaseSourceProcessor {
    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));){
            String line = null;
            String previousLineSqlCommand = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (Validator.isNotNull((String)(line = this.trimLine(line, false))) && !line.startsWith("\t")) {
                    String sqlCommand = StringUtil.split((String)line, (char)' ')[0];
                    if (Validator.isNotNull((String)previousLineSqlCommand) && !previousLineSqlCommand.equals(sqlCommand)) {
                        sb.append("\n");
                    }
                    previousLineSqlCommand = sqlCommand;
                } else {
                    previousLineSqlCommand = "";
                }
                String strippedQuotesLine = this.stripQuotes(line, '\'');
                if (strippedQuotesLine.contains("\"")) {
                    line = StringUtil.replace((String)line, (String)"\"", (String)"'");
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    @Override
    protected void format() throws Exception {
        String[] includes = new String[]{"**\\sql\\*.sql"};
        List<String> fileNames = this.getFileNames(new String[0], includes);
        for (String fileName : fileNames) {
            this.format(fileName);
        }
    }
}

