/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import com.liferay.util.ContentUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class PropertiesSourceProcessor
extends BaseSourceProcessor {
    private String _portalPortalPropertiesContent;

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        if (!portalSource && fileName.endsWith("portlet.properties")) {
            return this.formatPortletProperties(content);
        }
        if (fileName.endsWith("source-formatter.properties")) {
            this.formatSourceFormatterProperties(fileName, content);
        } else {
            this.formatPortalProperties(fileName, content);
        }
        return content;
    }

    @Override
    protected void format() throws Exception {
        this._portalPortalPropertiesContent = this.formatPortalPortalProperties();
        String[] includes = null;
        includes = portalSource ? new String[]{"**\\portal-ext.properties", "**\\portal-legacy-*.properties", "**\\source-formatter.properties"} : new String[]{"**\\portal.properties", "**\\portal-ext.properties", "**\\portlet.properties", "**\\source-formatter.properties"};
        List<String> fileNames = this.getFileNames(new String[0], includes);
        for (String fileName : fileNames) {
            this.format(fileName);
        }
    }

    protected String formatPortalPortalProperties() throws Exception {
        if (!portalSource) {
            return ContentUtil.get((String)"portal.properties");
        }
        String fileName = "portal-impl/src/portal.properties";
        File file = this.getFile(fileName, 4);
        String content = fileUtil.read(file);
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if ((line = this.trimLine(line, true)).startsWith("\t")) {
                    line = line.replaceFirst("\t", "    ");
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        this.processFormattedFile(file, fileName, content, newContent);
        return newContent;
    }

    protected void formatPortalProperties(String fileName, String content) throws Exception {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        int lineCount = 0;
        String line = null;
        int previousPos = -1;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            ++lineCount;
            int pos = line.indexOf("=");
            if (pos == -1) continue;
            String property = line.substring(0, pos + 1);
            property = property.trim();
            pos = this._portalPortalPropertiesContent.indexOf("    " + property);
            if (pos == -1) continue;
            if (pos < previousPos) {
                PropertiesSourceProcessor.processErrorMessage(fileName, "sort " + fileName + " " + lineCount);
            }
            previousPos = pos;
        }
    }

    protected String formatPortletProperties(String content) {
        if (!content.contains("include-and-override=portlet-ext.properties")) {
            content = "include-and-override=portlet-ext.properties\n\n" + content;
        }
        return content;
    }

    protected void formatSourceFormatterProperties(String fileName, String content) throws Exception {
        String path = "";
        int pos = fileName.lastIndexOf("/");
        if (pos != -1) {
            path = fileName.substring(0, pos + 1);
        }
        Properties properties = new Properties();
        FileInputStream inputStream = new FileInputStream(fileName);
        properties.load(inputStream);
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String value;
            String key = (String)enu.nextElement();
            if (!key.endsWith("excludes.files") || Validator.isNull((String)(value = properties.getProperty(key)))) continue;
            List propertyFileNames = ListUtil.fromString((String)value, (String)",");
            for (String propertyFileName : propertyFileNames) {
                pos = propertyFileName.indexOf("@");
                if (pos != -1) {
                    propertyFileName = propertyFileName.substring(0, pos);
                }
                if (fileUtil.exists(path + propertyFileName)) continue;
                PropertiesSourceProcessor.processErrorMessage(fileName, "Incorrect property value: " + propertyFileName + " " + fileName);
            }
        }
    }
}

